/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.catalina.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11Protocol;
import org.apache.geronimo.tomcat.connector.ConnectorGBean;
import org.apache.geronimo.tomcat.stats.ConnectorStats;

@GBean(name="Tomcat Connector")
public abstract class BaseHttp11ConnectorGBean
extends ConnectorGBean
implements BaseHttp11Protocol,
StatisticsProvider {
    protected String connectHost;
    private ConnectorStats connStatsProvider = new ConnectorStats();
    private boolean reset = true;

    public BaseHttp11ConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="protocol") String tomcatProtocol, @ParamAttribute(manageable=false, name="host") String host, @ParamAttribute(manageable=false, name="port") int port, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        super(name, initParams, tomcatProtocol, container, serverInfo, conn);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        this.connector.setAttribute("address", (Object)host);
        this.connector.setPort(port);
    }

    protected void initProtocol() {
    }

    @Override
    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getAddress();
            if (host == null || host.equals("0.0.0.0") || host.equals("0:0:0:0:0:0:0:1")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getCanonicalHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            if (host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            this.connectHost = host;
        }
        return this.getScheme().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    @Override
    public abstract int getDefaultPort();

    @Override
    public int getAcceptCount() {
        Object value = this.connector.getAttribute("acceptCount");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    @Override
    public String getAddress() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    @Override
    public int getBufferSize() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    @Override
    public String getCompressableMimeType() {
        return (String)this.connector.getAttribute("compressableMimeType");
    }

    @Override
    public String getCompression() {
        return (String)this.connector.getAttribute("compression");
    }

    @Override
    public int getConnectionLinger() {
        Object value = this.connector.getAttribute("connectionLinger");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    @Override
    public int getConnectionTimeout() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? 60000 : Integer.parseInt(value.toString());
    }

    @Override
    public boolean getDisableUploadTimeout() {
        Object value = this.connector.getAttribute("disableUploadTimeout");
        return value == null ? true : Boolean.valueOf(value.toString());
    }

    @Override
    public String getExecutor() {
        Object value = this.connector.getAttribute("executor");
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Executor) {
            return ((Executor)value).getName();
        }
        return value.getClass().getName();
    }

    @Override
    public String getHost() {
        return this.getAddress();
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    @Override
    public int getKeepAliveTimeout() {
        Object value = this.connector.getAttribute("keepAliveTimeout");
        return value == null ? this.getConnectionTimeout() : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxHttpHeaderSize() {
        Object value = this.connector.getAttribute("maxHttpHeaderSize");
        return value == null ? 4096 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxKeepAliveRequests() {
        Object value = this.connector.getAttribute("maxKeepAliveRequests");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    @Override
    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    @Override
    public String getNoCompressionUserAgents() {
        return (String)this.connector.getAttribute("noCompressionUserAgents");
    }

    @Override
    public int getPort() {
        return this.connector.getPort();
    }

    @Override
    public String getRestrictedUserAgents() {
        return (String)this.connector.getAttribute("restrictedUserAgents");
    }

    @Override
    public String getServer() {
        return (String)this.connector.getAttribute("server");
    }

    @Override
    public int getSocketBuffer() {
        Object value = this.connector.getAttribute("socketBuffer");
        return value == null ? 9000 : Integer.parseInt(value.toString());
    }

    @Override
    public boolean getTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : Boolean.valueOf(value.toString());
    }

    @Override
    public int getThreadPriority() {
        Object value = this.connector.getAttribute("threadPriority");
        return value == null ? 5 : Integer.parseInt(value.toString());
    }

    @Override
    @Persistent(manageable=false)
    public void setAcceptCount(int acceptCount) {
        this.connector.setAttribute("acceptCount", (Object)acceptCount);
    }

    @Override
    @Persistent(manageable=false)
    public void setAddress(String address) {
        this.connector.setAttribute("address", (Object)address);
    }

    @Override
    @Persistent(manageable=false)
    public void setBufferSize(int bufferSize) {
        this.connector.setAttribute("bufferSize", (Object)bufferSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setCompressableMimeType(String compressableMimeType) {
        this.connector.setAttribute("compressableMimeType", (Object)compressableMimeType);
    }

    @Override
    @Persistent(manageable=false)
    public void setCompression(String compression) {
        this.connector.setAttribute("compression", (Object)compression);
    }

    @Override
    @Persistent(manageable=false)
    public void setConnectionLinger(int connectionLinger) {
        this.connector.setAttribute("connectionLinger", (Object)connectionLinger);
    }

    @Override
    @Persistent(manageable=false)
    public void setConnectionTimeout(int connectionTimeout) {
        this.connector.setAttribute("connectionTimeout", (Object)connectionTimeout);
    }

    @Override
    @Persistent(manageable=false)
    public void setDisableUploadTimeout(boolean disableUploadTimeout) {
        this.connector.setAttribute("disableUploadTimeout", (Object)disableUploadTimeout);
    }

    @Override
    @Persistent(manageable=false)
    public void setExecutor(String executor) {
        this.connector.setAttribute("executor", (Object)executor);
    }

    @Override
    @Persistent(manageable=false)
    public void setHost(String host) {
        this.setAddress(host);
    }

    @Override
    @Persistent(manageable=false)
    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.connector.setAttribute("keepAliveTimeout", (Object)keepAliveTimeout);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.connector.setAttribute("maxHttpHeaderSize", (Object)maxHttpHeaderSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.connector.setAttribute("maxKeepAliveRequests", (Object)maxKeepAliveRequests);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxThreads(int maxThreads) {
        this.connector.setAttribute("maxThreads", (Object)maxThreads);
    }

    @Override
    @Persistent(manageable=false)
    public void setMaxSpareThreads(int maxSpareThreads) {
        this.connector.setAttribute("maxSpareThreads", (Object)maxSpareThreads);
    }

    @Override
    @Persistent(manageable=false)
    public void setMinSpareThreads(int minSpareThreads) {
        this.connector.setAttribute("minSpareThreads", (Object)minSpareThreads);
    }

    @Override
    @Persistent(manageable=false)
    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.connector.setAttribute("noCompressionUserAgents", (Object)noCompressionUserAgents);
    }

    @Override
    @Persistent(manageable=false)
    public void setPort(int port) {
        this.connector.setPort(port);
    }

    @Override
    @Persistent(manageable=false)
    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.connector.setAttribute("restrictedUserAgents", (Object)restrictedUserAgents);
    }

    @Override
    @Persistent(manageable=false)
    public void setServer(String server) {
        if (server.equals("")) {
            server = null;
        }
        this.connector.setAttribute("server", (Object)server);
    }

    @Override
    @Persistent(manageable=false)
    public void setSocketBuffer(int socketBuffer) {
        this.connector.setAttribute("socketBuffer", (Object)socketBuffer);
    }

    @Override
    @Persistent(manageable=false)
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.connector.setAttribute("tcpNoDelay", (Object)tcpNoDelay);
    }

    @Override
    @Persistent(manageable=false)
    public void setThreadPriority(int threadPriority) {
        this.connector.setAttribute("threadPriority", (Object)threadPriority);
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    @Override
    public Stats getStats() {
        String port = String.valueOf(this.getPort());
        if (this.reset) {
            this.reset = false;
            return this.connStatsProvider.getStats(port);
        }
        return this.connStatsProvider.updateStats(port);
    }

    @Override
    public void resetStats() {
        this.reset = true;
    }

    protected String getRelatedPathtoCatalinaHome(String path) {
        if (null != path && path.indexOf(System.getProperty("catalina.home")) != -1) {
            return path.substring(System.getProperty("catalina.home").length() + 1, path.length());
        }
        return path;
    }

    protected String getAbsolutePathBasedOnCatalinaHome(String path) {
        if (path == null) {
            return path;
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        File file = new File(new File(System.getProperty("catalina.home")), path);
        return file.getAbsolutePath();
    }
}

