/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.geronimo.crypto.EncryptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TomcatServerConfigManager {
    private static final Logger log = LoggerFactory.getLogger(TomcatServerConfigManager.class);
    private Document server_xml_dom_doc;
    private File server_XML_File;

    public TomcatServerConfigManager(File _server_XML_File) {
        this.server_XML_File = _server_XML_File;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.server_xml_dom_doc = docBuilder.parse(this.server_XML_File);
        }
        catch (Exception e) {
            log.error("Error when parsing server.xml:" + this.server_XML_File + " into dom doc", (Throwable)e);
        }
    }

    public synchronized void removeConnector(String name) {
        Element connector = this.findTargetConnector(name);
        if (null != connector) {
            connector.getParentNode().removeChild(connector);
        }
        this.persistServerConfig();
    }

    public synchronized void updateConnector(Map<String, String> attributesToUpdate, String uniqueConnectorName, String serviceName) {
        Element connector = this.findTargetConnector(uniqueConnectorName);
        if (null == connector) {
            connector = this.server_xml_dom_doc.createElement("Connector");
            Element service = this.getService(serviceName);
            NodeList ChildNodes = service.getChildNodes();
            Node lastConnectorNode = ChildNodes.item(ChildNodes.getLength() - 1);
            service.insertBefore(connector, lastConnectorNode);
        }
        for (Map.Entry<String, String> entry : attributesToUpdate.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            if (attributeName.equalsIgnoreCase("SSLEnabled")) {
                connector.setAttribute("SSLEnabled", attributeValue);
                continue;
            }
            connector.setAttribute(attributeName, attributeValue);
        }
        connector.setAttribute("name", uniqueConnectorName);
        this.persistServerConfig();
    }

    public synchronized void encryptPasswords() {
        boolean persisteRequired = false;
        NodeList connectors = this.server_xml_dom_doc.getElementsByTagName("Connector");
        for (int i = 0; i < connectors.getLength(); ++i) {
            Element connector = (Element)connectors.item(i);
            NamedNodeMap attributeMap = connector.getAttributes();
            for (int j = 0; j < attributeMap.getLength(); ++j) {
                String encryptedNodeValue;
                Node attribute = attributeMap.item(j);
                String nodeValue = attribute.getNodeValue();
                if (!attribute.getNodeName().equals("keystorePass") || nodeValue.equals(encryptedNodeValue = EncryptionManager.encrypt((Serializable)((Object)nodeValue)))) continue;
                persisteRequired = true;
                attribute.setNodeValue(encryptedNodeValue);
            }
        }
        if (persisteRequired) {
            this.persistServerConfig();
        }
    }

    private Element findTargetConnector(String name) {
        NodeList connectors = this.server_xml_dom_doc.getElementsByTagName("Connector");
        for (int i = 0; i < connectors.getLength(); ++i) {
            Element connector = (Element)connectors.item(i);
            if (!name.equals(connector.getAttribute("name"))) continue;
            return connector;
        }
        return null;
    }

    private Element getService(String serviceName) {
        NodeList services = this.server_xml_dom_doc.getElementsByTagName("Service");
        Element service = null;
        if (services == null || services.getLength() == 0) {
            throw new IllegalStateException("No services in server");
        }
        if (null == serviceName) {
            if (services.getLength() > 1) {
                throw new IllegalStateException("More than one service in server.  Provide name of desired server");
            }
            return (Element)services.item(0);
        }
        for (int i = 0; i < services.getLength(); ++i) {
            service = (Element)services.item(i);
            if (!service.getAttribute("name").equals(serviceName)) continue;
            return service;
        }
        return service;
    }

    private void persistServerConfig() {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            DOMSource source = new DOMSource(this.server_xml_dom_doc);
            StreamResult result = new StreamResult(this.server_XML_File);
            transformer.transform(source, result);
        }
        catch (Exception e1) {
            log.error("Error when persist modified DOM back to file:" + this.server_XML_File, (Throwable)e1);
        }
    }
}

