/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.jacc;

import java.io.IOException;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.apache.geronimo.security.jaspi.IdentityService;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.SecurityValve;

public class JACCSecurityValve
extends SecurityValve {
    private final String policyContextId;

    public JACCSecurityValve(Authenticator authenticator, Authorizer authorizer, IdentityService identityService, String policyContextId) {
        super(authenticator, authorizer, identityService);
        this.policyContextId = policyContextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String oldContextId = PolicyContext.getContextID();
        PolicyContext.setContextID((String)this.policyContextId);
        HttpServletRequest oldRequest = PolicyContextHandlerHttpServletRequest.pushContextData((HttpServletRequest)request);
        try {
            super.invoke(request, response);
        }
        finally {
            PolicyContext.setContextID((String)oldContextId);
            PolicyContextHandlerHttpServletRequest.popContextData((HttpServletRequest)oldRequest);
        }
    }
}

