/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.jacc;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.geronimo.security.ContextManager;
import org.ietf.jgss.GSSContext;

public class JACCRealm
implements Realm {
    public static final JACCRealm INSTANCE = new JACCRealm();
    private static final ThreadLocal<String> currentRequestWrapperName = new ThreadLocal();

    public static String setRequestWrapperName(String requestWrapperName) {
        String old = currentRequestWrapperName.get();
        currentRequestWrapperName.set(requestWrapperName);
        return old;
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        AccessControlContext acc = ContextManager.getCurrentContext();
        String name = currentRequestWrapperName.get();
        if (name == null || name.equals("jsp")) {
            name = "";
        }
        try {
            acc.checkPermission((Permission)new WebRoleRefPermission(name, role));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public Container getContainer() {
        return null;
    }

    public void setContainer(Container container) {
    }

    public String getInfo() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public Principal authenticate(String username, String credentials) {
        return null;
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        return null;
    }

    public void backgroundProcess() {
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        return new SecurityConstraint[0];
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraint, Context context) throws IOException {
        return false;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraint) throws IOException {
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return null;
    }
}

