/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMemberGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(StaticMemberGBean.class);
    public static final String J2EE_TYPE = "StaticMember";
    private final StaticMember staticMember;
    private final StaticMemberGBean nextStaticMember;
    public static final GBeanInfo GBEAN_INFO;

    public StaticMemberGBean() {
        this.staticMember = null;
        this.nextStaticMember = null;
    }

    public StaticMemberGBean(String className, Map initParams, StaticMemberGBean nextStaticMember) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("Must have a 'className' attribute.");
        }
        if (nextStaticMember != null) {
            if (!(nextStaticMember.getInternalObject() instanceof StaticMember)) {
                throw new IllegalArgumentException("nextStaticMember is not of type StaticMember.");
            }
            this.nextStaticMember = nextStaticMember;
        } else {
            this.nextStaticMember = null;
        }
        this.staticMember = (StaticMember)Class.forName(className).newInstance();
        this.setParameters(this.staticMember, initParams);
    }

    @Override
    public Object getInternalObject() {
        return this.staticMember;
    }

    public Object getNextStaticMember() {
        return this.nextStaticMember;
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Started StaticMember gbean.");
    }

    public void doStop() throws Exception {
        log.debug("Stopped StaticMember gbean.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)J2EE_TYPE, StaticMemberGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("NextStaticMember", StaticMemberGBean.class, J2EE_TYPE);
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.addOperation("getNextStaticMember", "Object");
        infoFactory.setConstructor(new String[]{"className", "initParams", "NextStaticMember"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

