/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.cluster.TransportGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(SenderGBean.class);
    public static final String J2EE_TYPE = "Sender";
    private final ChannelSender sender;
    public static final GBeanInfo GBEAN_INFO;

    public SenderGBean() {
        this.sender = null;
    }

    public SenderGBean(String className, Map initParams, TransportGBean transport) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("Must have a 'className' attribute.");
        }
        this.sender = (ChannelSender)Class.forName(className).newInstance();
        if (this.sender instanceof ReplicationTransmitter) {
            ReplicationTransmitter replicationTransmitter = (ReplicationTransmitter)this.sender;
            if (transport != null) {
                replicationTransmitter.setTransport((MultiPointSender)transport.getInternalObject());
            }
        } else {
            log.warn("Sender is not of type ReplicationTransmitter, no transport object will be set");
        }
        this.setParameters(this.sender, initParams);
    }

    @Override
    public Object getInternalObject() {
        return this.sender;
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Started Sender service gbean.");
    }

    public void doStop() throws Exception {
        log.debug("Stopped Sender gbean.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)J2EE_TYPE, SenderGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("Transport", TransportGBean.class, "Transport");
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.setConstructor(new String[]{"className", "initParams", "Transport"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

