/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.Base64;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class SpnegoAuthenticator
implements Authenticator {
    private static final String SPNEGO_AUTH = "SPNEGO";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private final LoginService loginService;
    private final String realmName;
    private final UserIdentity unauthenticatedIdentity;

    public SpnegoAuthenticator(LoginService loginService, String realmName, UserIdentity unauthenticatedIdentity) {
        this.loginService = loginService;
        this.realmName = realmName;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization == null) {
            if (isAuthMandatory) {
                response.addHeader(WWW_AUTHENTICATE, "Negotiate");
                try {
                    response.sendError(401);
                }
                catch (IOException e) {
                    throw new ServerAuthException(e);
                }
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
            }
            return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
        }
        String username = null;
        String password = null;
        authorization.toBytes();
        ByteChunk authorizationBC = authorization.getByteChunk();
        if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
            authorizationBC.setOffset(authorizationBC.getOffset() + 6);
            CharChunk authorizationCC = authorization.getCharChunk();
            Base64.decode((ByteChunk)authorizationBC, (CharChunk)authorizationCC);
            int colon = authorizationCC.indexOf(':');
            if (colon < 0) {
                username = authorizationCC.toString();
            } else {
                char[] buf = authorizationCC.getBuffer();
                username = new String(buf, 0, colon);
                password = new String(buf, colon + 1, authorizationCC.getEnd() - colon - 1);
            }
            authorizationBC.setOffset(authorizationBC.getOffset() - 6);
        } else if (authorizationBC.startsWithIgnoreCase("negotiate ", 0)) {
            authorizationBC.setOffset(authorizationBC.getOffset() + 10);
            username = authorizationBC.toString();
            authorizationBC.setOffset(authorizationBC.getOffset() - 10);
        }
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
        }
        if (isAuthMandatory) {
            try {
                StringBuilder authenticateCC = new StringBuilder();
                authenticateCC.append("Basic realm=\"");
                if (this.realmName == null) {
                    authenticateCC.append(request.getServerName());
                    authenticateCC.append(':');
                    authenticateCC.append(Integer.toString(request.getServerPort()));
                } else {
                    authenticateCC.append(this.realmName);
                }
                authenticateCC.append('\"');
                response.addHeader(WWW_AUTHENTICATE, authenticateCC.toString());
                response.sendError(401);
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
            }
            catch (IOException e) {
                throw new ServerAuthException(e);
            }
        }
        return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        return true;
    }

    @Override
    public String getAuthType() {
        return SPNEGO_AUTH;
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
        }
        return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
    }

    @Override
    public void logout(Request request) throws ServletException {
    }
}

