/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.coyote.ActionCode;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(FormAuthenticator.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    private final LoginService loginService;
    private final UserIdentity unauthenticatedIdentity;
    private final String loginPage;
    private final String erroryPage;

    public FormAuthenticator(LoginService loginService, UserIdentity unauthenticatedIdentity, String loginPage, String erroryPage) {
        this.loginService = loginService;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
        this.loginPage = loginPage;
        this.erroryPage = erroryPage;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        try {
            UserIdentity userIdentity;
            boolean loginAction;
            Session session = request.getSessionInternal(isAuthMandatory);
            if (session == null) {
                return new AuthResult(TomcatAuthStatus.SUCCESS, null, false);
            }
            if (this.matchRequest(request, session)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Restore request from session '" + session.getIdInternal() + "'");
                }
                if (!this.restoreRequest(request, session)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Proceed to restored request");
                    }
                    response.sendError(400);
                    return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null, false);
                }
            }
            if (cachedIdentity != null) {
                return new AuthResult(TomcatAuthStatus.SUCCESS, cachedIdentity, true);
            }
            MessageBytes uriMB = MessageBytes.newInstance();
            CharChunk uriCC = uriMB.getCharChunk();
            uriCC.setLimit(-1);
            String contextPath = request.getContextPath();
            String requestURI = request.getDecodedRequestURI();
            boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
            if (!loginAction) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Save request in session '" + session.getIdInternal() + "'");
                }
                if (!isAuthMandatory) {
                    return new AuthResult(TomcatAuthStatus.SUCCESS, null, false);
                }
                try {
                    this.saveRequest(request, session);
                }
                catch (IOException ioe) {
                    logger.debug("Request body too big to save during authentication");
                    response.sendError(400, sm.getString("authenticator.requestBodyTooBig"));
                    return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null, false);
                }
                this.forwardToLoginPage(request, response);
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, this.unauthenticatedIdentity, false);
            }
            String username = request.getParameter("j_username");
            String password = request.getParameter("j_password");
            if (logger.isDebugEnabled()) {
                logger.debug("Authenticating username '" + username + "'");
            }
            if ((userIdentity = this.loginService.login(username, password)) == null) {
                this.forwardToErrorPage(request, response);
                return new AuthResult(TomcatAuthStatus.SEND_FAILURE, this.unauthenticatedIdentity, false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication of '" + username + "' was successful");
            }
            if ((session = request.getSessionInternal(false)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("User took so long to log on the session expired");
                }
                response.sendError(408, sm.getString("authenticator.sessionExpired"));
                return new AuthResult(TomcatAuthStatus.SEND_FAILURE, this.unauthenticatedIdentity, false);
            }
            requestURI = this.savedRequestURL(session);
            if (logger.isDebugEnabled()) {
                logger.debug("Redirecting to original '" + requestURI + "'");
            }
            if (requestURI == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
                return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null, false);
            }
            response.sendRedirect(response.encodeRedirectURL(requestURI));
            return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, userIdentity, true);
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        return true;
    }

    @Override
    public String getAuthType() {
        return "FORM";
    }

    protected void forwardToLoginPage(Request request, HttpServletResponse response) {
        RequestDispatcher disp = request.getRequestDispatcher(this.loginPage);
        try {
            this.disableClientCache(response);
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
            response.flushBuffer();
        }
        catch (Throwable t) {
            logger.warn("Unexpected error forwarding to login page", t);
        }
    }

    protected void forwardToErrorPage(Request request, HttpServletResponse response) {
        RequestDispatcher disp = request.getRequestDispatcher(this.erroryPage);
        try {
            this.disableClientCache(response);
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
            response.flushBuffer();
        }
        catch (Throwable t) {
            logger.warn("Unexpected error forwarding to error page", t);
        }
    }

    protected boolean matchRequest(Request request, Session session) {
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        String requestURI = request.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        return requestURI.equals(sreq.getRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) throws IOException {
        ByteChunk body;
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie((Cookie)cookies.next());
        }
        MimeHeaders rmh = request.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cachable = "GET".equalsIgnoreCase(saved.getMethod()) || "HEAD".equalsIgnoreCase(saved.getMethod());
        Iterator names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cachable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString((String)values.next());
            }
        }
        request.clearLocales();
        Iterator locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale((Locale)locales.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        if ("POST".equalsIgnoreCase(saved.getMethod()) && (body = saved.getBody()) != null) {
            request.getCoyoteRequest().action(ActionCode.REQ_SET_BODY_REPLAY, (Object)body);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request.getCoyoteRequest().setContentType(contentType);
        }
        request.getCoyoteRequest().method().setString(saved.getMethod());
        request.getCoyoteRequest().queryString().setString(saved.getQueryString());
        request.getCoyoteRequest().requestURI().setString(saved.getRequestURI());
        this.disableClientCache(request.getResponse().getResponse());
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            int bytesRead;
            ByteChunk body = new ByteChunk();
            body.setLimit(request.getConnector().getMaxSavePostSize());
            byte[] buffer = new byte[4096];
            ServletInputStream is = request.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                body.append(buffer, 0, bytesRead);
            }
            saved.setContentType(request.getContentType());
            saved.setBody(body);
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        if (saved.getQueryString() != null) {
            StringBuilder sb = new StringBuilder(saved.getRequestURI());
            sb.append('?');
            sb.append(saved.getQueryString());
            return sb.toString();
        }
        return saved.getRequestURI();
    }

    private void disableClientCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "No-cache,no-store");
        response.setDateHeader("Expires", 1L);
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, true);
        }
        return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
    }

    @Override
    public void logout(Request request) {
    }
}

