/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.MD5Encoder;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class DigestAuthenticator
implements Authenticator {
    private static final MD5Encoder md5Encoder = new MD5Encoder();
    private static final MessageDigest md5Helper;
    private static final String key = "Catalina";
    private final LoginService loginService;
    private final String realmName;
    private final UserIdentity unauthenticatedIdentity;

    public DigestAuthenticator(LoginService loginService, String realmName, UserIdentity unauthenticatedIdentity) {
        this.loginService = loginService;
        this.realmName = realmName;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        UserIdentity userIdentity;
        String authorization = request.getHeader("authorization");
        if (authorization != null && (userIdentity = this.findPrincipal(request, authorization)) != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
        }
        if (isAuthMandatory) {
            String nOnce = this.generateNOnce(request);
            this.setAuthenticateHeader(response, nOnce);
            try {
                response.sendError(401);
            }
            catch (IOException e) {
                throw new ServerAuthException(e);
            }
            return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
        }
        return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        return true;
    }

    @Override
    public String getAuthType() {
        return "DIGEST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserIdentity findPrincipal(Request request, String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        String[] tokens = authorization.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        String method = request.getMethod();
        for (int i = 0; i < tokens.length; ++i) {
            String currentToken = tokens[i];
            if (currentToken.length() == 0) continue;
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = null;
        MessageDigest equalSign = md5Helper;
        synchronized (equalSign) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        String md5a2 = md5Encoder.encode(buffer);
        return this.loginService.login(userName, md5a2);
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNOnce(Request request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + key;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnceValue.getBytes());
        }
        nOnceValue = md5Encoder.encode(buffer);
        return nOnceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthenticateHeader(HttpServletResponse response, String nOnce) {
        byte[] buffer;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnce.getBytes());
        }
        String authenticateHeader = "Digest realm=\"" + this.realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + md5Encoder.encode(buffer) + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
        }
        return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
    }

    @Override
    public void logout(Request request) {
    }

    static {
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

