/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipInputStream;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.openejb.cdi.OpenWebBeansWebInitializer;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.BundleDirContext;
import org.apache.geronimo.tomcat.GeronimoFileDirContext;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatDeploymentWatcher;
import org.apache.geronimo.tomcat.TomcatInstanceManager;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;
import org.apache.geronimo.tomcat.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.OWBBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.PolicyContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.UserTransactionBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.WebApplicationIdentityBeforeAfter;
import org.apache.geronimo.tomcat.listener.DispatchListener;
import org.apache.geronimo.tomcat.listener.RunAsInstanceListener;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.GeronimoBeforeAfterValve;
import org.apache.geronimo.tomcat.valve.ProtectedTargetValve;
import org.apache.geronimo.web.security.SpecSecurityBuilder;
import org.apache.geronimo.web.security.WebSecurityConstraintStore;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.apache.naming.resources.FileDirContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.webbeans.config.WebBeansContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class GeronimoStandardContext
extends StandardContext {
    private static final long serialVersionUID = 3834587716552831032L;
    private static final boolean allowLinking = Boolean.getBoolean("org.apache.geronimo.tomcat.GeronimoStandardContext.allowLinking");
    private Subject defaultSubject = null;
    private RunAsSource runAsSource = RunAsSource.NULL;
    private Map<String, WebServiceContainer> webServiceMap = null;
    private boolean pipelineInitialized;
    private BeforeAfter beforeAfter = null;
    private int contextCount = 0;
    private boolean authenticatorInstalled;
    private ConfigurationFactory configurationFactory;
    private String policyContextId;
    private WebSecurityConstraintStore webSecurityConstraintStore;
    private ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager;
    private Bundle bundle;
    private ServiceRegistration serviceRegistration;
    private ThreadLocal<Stack<BeforeAfterContext>> beforeAfterContexts = new ThreadLocal<Stack<BeforeAfterContext>>(){

        @Override
        protected Stack<BeforeAfterContext> initialValue() {
            return new Stack<BeforeAfterContext>();
        }
    };
    private static final Set<String> FILTERED_UNEXTRACTED_ARTIFACT_IDS = new HashSet<String>();
    private final Object instanceListenersLock = new Object();
    private final Object wrapperLifecyclesLock = new Object();
    private final Object wrapperListenersLock = new Object();

    public GeronimoStandardContext() {
        this.setXmlNamespaceAware(true);
        this.setProcessTlds(false);
        this.setUseHttpOnly(false);
        this.setXmlValidation(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        List<LifecycleListener> listenerChain;
        WebBeansContext owbContext;
        this.bundle = ctx.getBundle();
        this.setResources(this.createDirContext(ctx));
        javax.naming.Context enc = ctx.getJndiContext();
        this.setInstanceManager(ctx.getInstanceManager());
        ServletContext servletContext = this.getServletContext();
        if (ctx instanceof TomcatWebAppContext) {
            TomcatWebAppContext tomcatWebAppContext = (TomcatWebAppContext)ctx;
            this.setJavaVMs(tomcatWebAppContext.getJavaVMs());
            this.setServer(tomcatWebAppContext.getServer());
            this.setJ2EEApplication(tomcatWebAppContext.getJ2EEApplication());
            this.setJ2EEServer(tomcatWebAppContext.getJ2EEServer());
            servletContext.setAttribute("WEB_APP_NAME", (Object)tomcatWebAppContext.getWARName());
            if (tomcatWebAppContext.getRuntimeCustomizer() != null) {
                HashMap attributes = new HashMap();
                HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
                customizerContext.put(Map.class, attributes);
                customizerContext.put(javax.naming.Context.class, enc);
                tomcatWebAppContext.getRuntimeCustomizer().customize(customizerContext);
                for (Map.Entry entry : attributes.entrySet()) {
                    servletContext.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            this.applicationPolicyConfigurationManager = tomcatWebAppContext.getApplicationPolicyConfigurationManager();
            if (tomcatWebAppContext.getSecurityHolder() != null) {
                this.configurationFactory = tomcatWebAppContext.getSecurityHolder().getConfigurationFactory();
            }
            float schemaVersion = ((Float)tomcatWebAppContext.getDeploymentAttribute("SCHEMA_VERSION")).floatValue();
            boolean metaComplete = (Boolean)tomcatWebAppContext.getDeploymentAttribute("META_COMPLETE");
            this.webSecurityConstraintStore = new WebSecurityConstraintStore(tomcatWebAppContext.getWebAppInfo(), this.bundle, schemaVersion >= 2.5f && !metaComplete, this.getInternalServletContext());
            servletContext.setAttribute(InstanceManager.class.getName(), (Object)ctx.getInstanceManager());
            List orderedLists = (List)tomcatWebAppContext.getDeploymentAttribute("ORDERED_LIBS");
            if (orderedLists != null) {
                servletContext.setAttribute("javax.servlet.context.orderedLibs", Collections.unmodifiableList(orderedLists));
            }
            Map servletContainerInitializerClassNamesMap = (Map)tomcatWebAppContext.getDeploymentAttribute("SERVLET_CONTAINER_INITIALIZERS");
            Bundle bundle = tomcatWebAppContext.getBundle();
            if (servletContainerInitializerClassNamesMap != null) {
                for (Map.Entry entry : servletContainerInitializerClassNamesMap.entrySet()) {
                    String servletContainerInitializerClassName = (String)entry.getKey();
                    Set classNames = (Set)entry.getValue();
                    try {
                        ServletContainerInitializer servletContainerInitializer = (ServletContainerInitializer)bundle.loadClass(servletContainerInitializerClassName).newInstance();
                        if (classNames == null || classNames.size() == 0) {
                            this.addServletContainerInitializer(servletContainerInitializer, null);
                            continue;
                        }
                        HashSet<Class> classSet = new HashSet<Class>();
                        for (String string : classNames) {
                            try {
                                classSet.add(bundle.loadClass(string));
                            }
                            catch (ClassNotFoundException e) {
                                this.getLogger().warn((Object)("Fail to load class " + string + " interested by ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                            }
                        }
                        this.addServletContainerInitializer(servletContainerInitializer, classSet);
                    }
                    catch (IllegalAccessException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                }
            }
        }
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, index++, ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        if (enc != null) {
            interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        }
        if ((owbContext = ctx.getOWBContext()) == null) {
            owbContext = OpenWebBeansWebInitializer.newWebBeansContext(null);
        }
        OpenWebBeansWebInitializer.initializeServletContext((WebBeansContext)owbContext, (ServletContext)servletContext);
        if (this.getInstanceManager() instanceof TomcatInstanceManager) {
            ((TomcatInstanceManager)this.getInstanceManager()).setOWBContext(owbContext);
        }
        interceptor = new OWBBeforeAfter(interceptor, index++, servletContext, owbContext);
        SecurityHolder securityHolder = ctx.getSecurityHolder();
        if (securityHolder != null) {
            this.runAsSource = securityHolder.getRunAsSource();
            if (securityHolder.getPolicyContextID() != null) {
                this.policyContextId = securityHolder.getPolicyContextID();
                PolicyContext.setContextID((String)this.policyContextId);
                this.defaultSubject = securityHolder.getDefaultSubject();
                if (this.defaultSubject == null) {
                    this.defaultSubject = ContextManager.EMPTY;
                }
                interceptor = new PolicyContextBeforeAfter(interceptor, index++, index++, index++, this.policyContextId, this.defaultSubject);
            }
        }
        interceptor = new UserTransactionBeforeAfter(interceptor, index++, ctx.getUserTransaction());
        interceptor = new WebApplicationIdentityBeforeAfter(interceptor, index++, ctx.getAbstractName().toString());
        this.addValve((Valve)new ProtectedTargetValve());
        Valve clusteredValve = ctx.getClusteredValve();
        if (null != clusteredValve) {
            this.addValve(clusteredValve);
        }
        GeronimoBeforeAfterValve geronimoBAValve = new GeronimoBeforeAfterValve(interceptor, index);
        this.addValve((Valve)geronimoBAValve);
        this.beforeAfter = interceptor;
        this.contextCount = index;
        this.addValve((Valve)new SystemMethodValve());
        List<Valve> valveChain = ctx.getValveChain();
        if (valveChain != null) {
            for (Valve valve : valveChain) {
                this.addValve(valve);
            }
        }
        if ((listenerChain = ctx.getLifecycleListenerChain()) != null) {
            for (LifecycleListener listener : listenerChain) {
                this.addLifecycleListener(listener);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        ClassLoader oldClassLoader = this.bindThread();
        try {
            this.webServiceMap = ctx.getWebServices();
        }
        finally {
            this.unbindThread(oldClassLoader);
        }
        Map<String, String> contextAttributes = ctx.getContextAttributes();
        if (!ctx.getContextAttributes().containsKey("allowLinking")) {
            contextAttributes.put("allowLinking", String.valueOf(allowLinking));
        }
        for (Map.Entry entry : contextAttributes.entrySet()) {
            if (IntrospectionUtils.setProperty((Object)((Object)this), (String)((String)entry.getKey()), (String)((String)entry.getValue())) || !this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn((Object)("Fail to configure attribute " + (String)entry.getKey() + " with value " + (String)entry.getValue() + ", please check whether the attribute exists or is typo correctly"));
        }
        this.addInstanceListener(DispatchListener.class.getName());
        if (this.runAsSource != null) {
            this.addInstanceListener(RunAsInstanceListener.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        InstanceListener listener;
        StandardWrapper wrapper = null;
        if (this.getWrapperClass() != null) {
            try {
                wrapper = (Wrapper)this.getInstanceManager().newInstance(this.getWrapperClass());
            }
            catch (Throwable t) {
                this.getLogger().error((Object)"createWrapper", t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            for (String instanceListener : this.findInstanceListeners()) {
                try {
                    listener = (InstanceListener)this.getInstanceManager().newInstance(instanceListener);
                    wrapper.addInstanceListener(listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperLifecyclesLock;
        synchronized (object) {
            for (String wrapperLifecycle : this.findWrapperLifecycles()) {
                try {
                    listener = (LifecycleListener)this.getInstanceManager().newInstance(wrapperLifecycle);
                    wrapper.addLifecycleListener((LifecycleListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperListenersLock;
        synchronized (object) {
            for (String wrapperListener : this.findWrapperListeners()) {
                try {
                    listener = (ContainerListener)this.getInstanceManager().newInstance(wrapperListener);
                    wrapper.addContainerListener((ContainerListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
        }
        try {
            super.backgroundProcess();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(beforeAfterContext, null, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
        }
        try {
            this.stop();
            this.destroy();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(beforeAfterContext, null, null, 0);
            }
        }
    }

    protected void initInternal() throws LifecycleException {
        String docBase = this.getDocBase();
        super.initInternal();
        this.setDocBase(docBase);
    }

    protected void startInternal() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                Valve valve = this.getPipeline().getFirst();
                valve.invoke(null, null);
                if (this.hasRunAsServlet()) {
                    if (this.runAsSource == null) {
                        throw new GeronimoSecurityException("web.xml or annotation specifies a run-as role but no subject configuration supplied for run-as roles");
                    }
                } else {
                    this.removeInstanceListener(RunAsInstanceListener.class.getName());
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof LifecycleException) {
                    throw (LifecycleException)e.getCause();
                }
                throw new LifecycleException((Throwable)e);
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
            SpecSecurityBuilder specSecurityBuilder = new SpecSecurityBuilder(this.webSecurityConstraintStore.exportMergedWebAppInfo());
            HashMap<String, ComponentPermissions> contextIdPermissionsMap = new HashMap<String, ComponentPermissions>();
            contextIdPermissionsMap.put(this.getPolicyContextId(), specSecurityBuilder.buildSpecSecurityConfig());
            if (this.applicationPolicyConfigurationManager != null) {
                try {
                    this.applicationPolicyConfigurationManager.updateApplicationPolicyConfiguration(contextIdPermissionsMap);
                }
                catch (LoginException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                catch (PolicyContextException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                finally {
                    specSecurityBuilder.clear();
                }
            }
            if (WebApplicationUtils.isWebApplicationBundle((Bundle)this.bundle)) {
                this.serviceRegistration = WebApplicationUtils.registerServletContext((Bundle)this.bundle, (ServletContext)this.getServletContext());
            }
        } else {
            super.startInternal();
        }
    }

    public synchronized void setLoader(final Loader delegate) {
        Loader loader = new Loader(){

            public void backgroundProcess() {
                delegate.backgroundProcess();
            }

            public ClassLoader getClassLoader() {
                return GeronimoStandardContext.this.parentClassLoader;
            }

            public Container getContainer() {
                return delegate.getContainer();
            }

            public void setContainer(Container container) {
                delegate.setContainer(container);
            }

            public boolean getDelegate() {
                return delegate.getDelegate();
            }

            public void setDelegate(boolean delegateBoolean) {
                delegate.setDelegate(delegateBoolean);
            }

            public String getInfo() {
                return delegate.getInfo();
            }

            public boolean getReloadable() {
                return false;
            }

            public void setReloadable(boolean reloadable) {
                if (reloadable) {
                    throw new UnsupportedOperationException("Reloadable context is not supported.");
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                delegate.addPropertyChangeListener(listener);
            }

            public void addRepository(String repository) {
                delegate.addRepository(repository);
            }

            public String[] findRepositories() {
                return delegate.findRepositories();
            }

            public boolean modified() {
                return delegate.modified();
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                delegate.removePropertyChangeListener(listener);
            }
        };
        super.setLoader(loader);
    }

    public ServletContext getInternalServletContext() {
        return this.context;
    }

    private boolean isSystemArtifact(Bundle bundle) {
        String noVersionArtifact;
        String[] artifactFragments;
        String bundleLocation = bundle.getLocation();
        return bundleLocation.startsWith("mvn:") && (artifactFragments = bundleLocation.substring(4).split("[/]")).length == 4 && FILTERED_UNEXTRACTED_ARTIFACT_IDS.contains(noVersionArtifact = artifactFragments[0] + "/" + artifactFragments[1] + "//" + artifactFragments[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DirContext createDirContext(TomcatContext tomcatContext) throws DeploymentException {
        block30: {
            block29: {
                block28: {
                    altDirContexts = new ArrayList<DirContext>();
                    engine = (Engine)this.getParent().getParent();
                    serviceName = engine.getService().getName();
                    engineName = engine.getName();
                    hostName = this.getParent().getName();
                    tomcatHome = System.getProperty("catalina.home");
                    tempRootDirectory = new File(tomcatHome + File.separator + "resources" + File.separator + serviceName + File.separator + engineName + File.separator + hostName + File.separator + (this.getName().equals("/") != false ? "_" : this.getName()));
                    webAppInfo = tomcatContext.getWebAppInfo();
                    applicationStageConfiguration = (String)webAppInfo.contextParams.get("org.apache.geronimo.webapplication.stage");
                    globalStageConfiguration = System.getProperty("org.apache.geronimo.webapplication.stage", "PRODUCTION");
                    developmentStage = applicationStageConfiguration == null ? globalStageConfiguration.equalsIgnoreCase("DEVELOPMENT") : applicationStageConfiguration.equalsIgnoreCase("DEVELOPMENT");
                    systemArtifact = this.isSystemArtifact(this.bundle);
                    globalGetRealPathConfiguration = System.getProperty("org.apache.geronimo.webapplication.getrealpath.support");
                    applicationGetRealPathConfiguration = (String)webAppInfo.contextParams.get("org.apache.geronimo.webapplication.getrealpath.support");
                    getRealPathSupportRequired = applicationGetRealPathConfiguration == null ? !"false".equalsIgnoreCase(globalGetRealPathConfiguration) : "false".equalsIgnoreCase(applicationGetRealPathConfiguration) == false;
                    this.deleteTempDirectoryOnUndeployed(tomcatContext, tempRootDirectory);
                    checksumFile = new File(tempRootDirectory, "checksum.flag");
                    refreshmentRequired = false;
                    checksum = null;
                    try {
                        bundleURL = new URL(this.bundle.getLocation());
                        checksum = GeronimoStandardContext.getChecksum(bundleURL);
                        if (checksumFile.exists()) {
                            savedChecksum = GeronimoStandardContext.readChecksum(checksumFile);
                            if (!Arrays.equals(checksum, savedChecksum)) {
                                refreshmentRequired = true;
                            }
                            break block28;
                        }
                        refreshmentRequired = true;
                    }
                    catch (Exception e) {
                        this.getLogger().warn((Object)"Unable to compute module checksum", (Throwable)e);
                        refreshmentRequired = true;
                    }
                }
                if (refreshmentRequired && checksum != null) {
                    tempRootDirectory.mkdirs();
                    try {
                        GeronimoStandardContext.writeChecksum(checksumFile, checksum);
                    }
                    catch (Exception e) {
                        this.getLogger().error((Object)"Unable to write module checksum file", (Throwable)e);
                    }
                }
                jarResourceRootDirectory = new File(tempRootDirectory, "jar_resources");
                if (refreshmentRequired || !jarResourceRootDirectory.exists()) {
                    try {
                        FileUtils.recursiveDelete((File)jarResourceRootDirectory);
                        jarResourceRootDirectory.mkdirs();
                        en = tomcatContext.getBundle().findEntries(tomcatContext.getModulePath() != null ? tomcatContext.getModulePath() + "/WEB-INF/lib" : "WEB-INF/lib", "*.jar", false);
                        if (en == null) break block29;
                        while (en.hasMoreElements()) {
                            jarUrl = (URL)en.nextElement();
                            jarResourceDirectory = new File(jarResourceRootDirectory, jarUrl.getFile().substring(jarUrl.getFile().lastIndexOf(47) + 1));
                            jarResourceDirectory.mkdirs();
                            in = null;
                            try {
                                in = new ZipInputStream(jarUrl.openStream());
                                while ((zipEntry = in.getNextEntry()) != null) {
                                    name = zipEntry.getName();
                                    if (name.indexOf("META-INF/resources") != 0) continue;
                                    if (zipEntry.isDirectory()) {
                                        new File(jarResourceDirectory, name).mkdirs();
                                        continue;
                                    }
                                    resourceFile = new File(jarResourceDirectory, name);
                                    resourceFile.getParentFile().mkdirs();
                                    out = null;
                                    try {
                                        out = new FileOutputStream(resourceFile);
                                        IOUtils.copy((InputStream)in, (OutputStream)out);
                                    }
                                    catch (Throwable var29_38) {
                                        IOUtils.close(out);
                                        throw var29_38;
                                    }
                                    IOUtils.close((Closeable)out);
                                }
                            }
                            catch (Throwable var30_39) {
                                IOUtils.close(in);
                                throw var30_39;
                            }
                            IOUtils.close((Closeable)in);
                        }
                    }
                    catch (IOException e) {
                        checksumFile.delete();
                        throw new DeploymentException("Fail to create static resoruce cache for jar files in WEB-INF folder", (Throwable)e);
                    }
                }
            }
            for (File resourceDirectory : jarResourceRootDirectory.listFiles()) {
                if (!resourceDirectory.isDirectory() || !resourceDirectory.getName().endsWith(".jar") || resourceDirectory.listFiles().length <= 0) continue;
                fileDirContext = new FileDirContext();
                fileDirContext.setAllowLinking(GeronimoStandardContext.allowLinking);
                fileDirContext.setDocBase(resourceDirectory.getAbsolutePath());
                altDirContexts.add((DirContext)fileDirContext);
            }
            if (systemArtifact || !getRealPathSupportRequired && !developmentStage) {
                return new BundleDirContext(tomcatContext.getBundle(), tomcatContext.getModulePath(), altDirContexts, null);
            }
            realPathTempDirecotory = new File(tempRootDirectory, "real_path");
            if (!refreshmentRequired && realPathTempDirecotory.exists()) break block30;
            FileUtils.recursiveDelete((File)realPathTempDirecotory);
            realPathTempDirecotory.mkdirs();
            zipIn = null;
            try {
                zipIn = new ZipInputStream(new URL(this.bundle.getLocation()).openStream());
                entry = null;
                v0 = modulePath = tomcatContext.getModulePath() == null ? "" : tomcatContext.getModulePath();
                while ((entry = zipIn.getNextEntry()) != null) {
                    if (!entry.getName().startsWith(modulePath)) continue;
                    v1 = subPath = entry.getName().equals(modulePath) != false ? "" : entry.getName().substring(modulePath.length());
                    if (entry.isDirectory()) {
                        dir = new File(realPathTempDirecotory, subPath);
                        dir.mkdirs();
                        continue;
                    }
                    file = new File(realPathTempDirecotory, subPath);
                    file.getParentFile().mkdirs();
                    out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        IOUtils.copy((InputStream)zipIn, (OutputStream)out);
                        out.flush();
                    }
                    catch (Throwable var31_40) {
                        IOUtils.close(out);
                        throw var31_40;
                    }
                    IOUtils.close((Closeable)out);
                }
                ** GOTO lbl144
            }
            catch (IOException e) {
                try {
                    checksumFile.delete();
                    this.getLogger().warn((Object)"fail to extract the bundle, getRealPath might not work", (Throwable)e);
                }
                catch (Throwable var32_41) {
                    IOUtils.close(zipIn);
                    throw var32_41;
                }
lbl144:
                // 1 sources

                IOUtils.close((Closeable)zipIn);
                IOUtils.close((Closeable)zipIn);
            }
        }
        if (developmentStage) {
            fileDirContext = new GeronimoFileDirContext(altDirContexts);
            fileDirContext.setAllowLinking(GeronimoStandardContext.allowLinking);
            this.setDocBase(realPathTempDirecotory.getAbsolutePath());
            return fileDirContext;
        }
        return new BundleDirContext(tomcatContext.getBundle(), tomcatContext.getModulePath(), altDirContexts, realPathTempDirecotory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTempDirectoryOnUndeployed(TomcatContext tomcatContext, File tempDirectory) {
        if (!(tomcatContext instanceof TomcatWebAppContext)) {
            return;
        }
        TomcatWebAppContext tomcatWebAppContext = (TomcatWebAppContext)tomcatContext;
        BundleContext bundleContext = this.bundle.getBundleContext();
        ServiceReference tomcatDeploymentWatcherReference = null;
        try {
            tomcatDeploymentWatcherReference = bundleContext.getServiceReference(TomcatDeploymentWatcher.class.getName());
            if (tomcatDeploymentWatcherReference == null) {
                return;
            }
            TomcatDeploymentWatcher tomcatDeploymentWatcher = (TomcatDeploymentWatcher)bundleContext.getService(tomcatDeploymentWatcherReference);
            tomcatDeploymentWatcher.deleteOnUndeployed(tomcatWebAppContext.getAbstractName(), tempDirectory);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to add temporary directory " + tempDirectory + "to the Tomcat deployment watcher, that folder will not be delete on the undeployment"), (Throwable)e);
        }
        finally {
            if (tomcatDeploymentWatcherReference != null) {
                try {
                    bundleContext.ungetService(tomcatDeploymentWatcherReference);
                }
                catch (Exception e) {}
            }
        }
    }

    public BeforeAfter getBeforeAfter() {
        return this.beforeAfter;
    }

    public int getContextCount() {
        return this.contextCount;
    }

    protected boolean hasRunAsServlet() {
        for (Container servlet : this.findChildren()) {
            if (!(servlet instanceof Wrapper) || ((Wrapper)servlet).getRunAs() == null) continue;
            return true;
        }
        return false;
    }

    public Subject getSubjectForRole(String runAsRole) {
        return this.runAsSource.getSubjectForRole(runAsRole);
    }

    public boolean isAuthenticatorInstalled() {
        return this.authenticatorInstalled;
    }

    public void setAuthenticatorInstalled(boolean authenticatorInstalled) {
        this.authenticatorInstalled = authenticatorInstalled;
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getPolicyContextId() {
        return this.policyContextId;
    }

    public String getBasePath() {
        if (this.getDocBase() == null) {
            return null;
        }
        return super.getBasePath();
    }

    public ServletRegistration.Dynamic dynamicServletAdded(Wrapper wrapper) {
        ApplicationServletRegistration registration = new ApplicationServletRegistration(wrapper, (Context)this);
        if (wrapper.getServlet() == null || this.webSecurityConstraintStore.isContainerCreatedDynamicServlet(wrapper.getServlet())) {
            this.webSecurityConstraintStore.addContainerCreatedDynamicServletEntry((ServletRegistration.Dynamic)registration, wrapper.getServletClass());
        }
        ClassLoader cl = this.getParentClassLoader();
        try {
            WebServiceContainer webServiceContainer;
            Class<?> baseServletClass = cl.loadClass(Servlet.class.getName());
            Class<?> servletClass = cl.loadClass(wrapper.getServletClass());
            if (!baseServletClass.isAssignableFrom(servletClass) && this.webServiceMap != null && (webServiceContainer = this.webServiceMap.get(wrapper.getName())) != null) {
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return registration;
    }

    public void dynamicServletCreated(Servlet servlet) {
        this.webSecurityConstraintStore.addContainerCreatedDynamicServlet(servlet);
    }

    public Set<String> addServletSecurity(ApplicationServletRegistration registration, ServletSecurityElement servletSecurityElement) {
        return this.webSecurityConstraintStore.setDynamicServletSecurity((ServletRegistration.Dynamic)registration, servletSecurityElement);
    }

    public void addSecurityRole(String role) {
        super.addSecurityRole(role);
        this.webSecurityConstraintStore.declareRoles(new String[]{role});
    }

    protected ClassLoader bindThread() {
        ClassLoader oldClassLoader = super.bindThread();
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
            this.beforeAfterContexts.get().push(beforeAfterContext);
        }
        return oldClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindThread(ClassLoader oldContextClassLoader) {
        try {
            super.unbindThread(oldContextClassLoader);
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(this.beforeAfterContexts.get().pop(), null, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getChecksum(URL url) throws Exception {
        long lastModified;
        InputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                URLConnection connection = url.openConnection();
                in = connection.getInputStream();
                lastModified = connection.getLastModified();
                if (lastModified != 0L) break block3;
                byArray = GeronimoStandardContext.calculateChecksum(in, "SHA-1");
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close((Closeable)in);
            return byArray;
        }
        byte[] byArray = GeronimoStandardContext.toByteArray(lastModified);
        IOUtils.close((Closeable)in);
        return byArray;
    }

    private static byte[] calculateChecksum(InputStream stream, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest digester = MessageDigest.getInstance(algorithm);
        digester.reset();
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = stream.read(buf, 0, buf.length)) != -1) {
            digester.update(buf, 0, len);
        }
        return digester.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChecksum(File file, byte[] data) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(data);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readChecksum(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = IOUtils.getBytes((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }

    private static byte[] toByteArray(long value) {
        byte[] buffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return buffer;
    }

    static {
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.configs/remote-deploy-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/plugin-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/osgi-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/openejb-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.configs/welcome-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins.monitoring/mconsole-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/activemq-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/debugviews-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/sysdb-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.plugins/plancreator-console-tomcat//car");
        FILTERED_UNEXTRACTED_ARTIFACT_IDS.add("org.apache.geronimo.configs/uddi-tomcat//car");
    }

    private class SystemMethodValve
    extends ValveBase {
        public SystemMethodValve() {
            super(true);
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                try {
                    GeronimoStandardContext.super.startInternal();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
                if (!GeronimoStandardContext.this.getAvailable()) {
                    throw new IOException("Context did not start for an unknown reason");
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

