/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class SecurityValve
extends ValveBase {
    private final Authenticator authenticator;
    private final Authorizer authorizer;
    private final IdentityService identityService;

    public SecurityValve(Authenticator authenticator, Authorizer authorizer, IdentityService identityService) {
        super(true);
        this.authenticator = authenticator;
        this.authorizer = authorizer;
        this.identityService = identityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object constraints = this.authorizer.getConstraints(request);
        if (!this.authorizer.hasUserDataPermissions(request, constraints)) {
            if (!response.isError()) {
                response.sendError(403);
            }
            return;
        }
        boolean isAuthMandatory = this.authorizer.isAuthMandatory(request, constraints);
        try {
            AuthResult authResult = this.authenticator.validateRequest(request, response, isAuthMandatory);
            TomcatAuthStatus authStatus = authResult.getAuthStatus();
            if (authStatus == TomcatAuthStatus.FAILURE) {
                return;
            }
            if (authStatus == TomcatAuthStatus.SEND_CONTINUE) {
                return;
            }
            if (authStatus == TomcatAuthStatus.SEND_FAILURE) {
                return;
            }
            if (authStatus == TomcatAuthStatus.SEND_SUCCESS) {
                return;
            }
            if (authStatus == TomcatAuthStatus.SUCCESS) {
                request.setAuthType(this.authenticator.getAuthType());
                UserIdentity userIdentity = authResult.getUserIdentity();
                Principal principal = userIdentity == null ? null : userIdentity.getUserPrincipal();
                request.setUserPrincipal(principal);
                if (isAuthMandatory && !this.authorizer.hasResourcePermissions(request, authResult, constraints, userIdentity)) {
                    if (!response.isError()) {
                        response.sendError(403);
                    }
                    return;
                }
                Object previous = this.identityService.associate(userIdentity);
                try {
                    this.getNext().invoke(request, response);
                }
                finally {
                    this.identityService.dissociate(previous);
                }
            } else {
                throw new ServletException("unexpected auth status: " + (Object)((Object)authStatus));
            }
            this.authenticator.secureResponse(request, response, authResult);
        }
        catch (ServerAuthException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

