/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.NamingResources;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.geronimo.tomcat.model.NamingResourcesType;
import org.apache.geronimo.tomcat.model.ServiceType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ServerType", propOrder={"listener", "globalNamingResources", "service"})
public class ServerType {
    private static final Logger logger = LoggerFactory.getLogger(ServerType.class);
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlElement(name="GlobalNamingResources")
    protected List<NamingResourcesType> globalNamingResources;
    @XmlElement(name="Service")
    protected List<ServiceType> service;
    @XmlAttribute
    protected String className = StandardServer.class.getName();
    @XmlAttribute
    protected Integer port;
    @XmlAttribute
    protected String shutdown;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public List<NamingResourcesType> getGlobalNamingResources() {
        if (this.globalNamingResources == null) {
            this.globalNamingResources = new ArrayList<NamingResourcesType>();
        }
        return this.globalNamingResources;
    }

    public List<ServiceType> getService() {
        if (this.service == null) {
            this.service = new ArrayList<ServiceType>();
        }
        return this.service;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        this.port = value;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String value) {
        this.shutdown = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Server build(ClassLoader cl, Kernel kernel) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Server instance = (Server)recipe.create(cl);
        instance.setPort(this.port.intValue());
        instance.setShutdown(this.shutdown);
        if (instance instanceof Lifecycle) {
            Server lifecycle = instance;
            for (ListenerType listenerType : this.getListener()) {
                LifecycleListener listener = listenerType.getLifecycleListener(cl);
                lifecycle.addLifecycleListener(listener);
            }
        }
        NamingResources globalNamingResources = new NamingResources();
        if (this.getGlobalNamingResources().size() > 0) {
            logger.warn("All the resource settings in the server.xml are ignored, please use Geronimo deployment plan to define those configurations");
        }
        instance.setGlobalNamingResources(globalNamingResources);
        for (ServiceType serviceType : this.getService()) {
            Service service = serviceType.getService(cl, kernel);
            instance.addService(service);
        }
        return instance;
    }
}

