/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.geronimo.tomcat.cluster.Router;

public class JkRouter
implements Router {
    private final String nodeName;

    public JkRouter(String nodeName) {
        if (null == nodeName) {
            throw new IllegalArgumentException("nodeName is required");
        }
        this.nodeName = nodeName;
    }

    @Override
    public String replaceRoutingInfoInRequestedSessionId(Request request) {
        int index;
        String requestedSessionId = request.getRequestedSessionId();
        if (null != requestedSessionId && !requestedSessionId.endsWith("." + this.nodeName) && 0 < (index = requestedSessionId.indexOf("."))) {
            String newRequestedSessionId = requestedSessionId.substring(0, index + 1);
            newRequestedSessionId = newRequestedSessionId + this.nodeName;
            request.setRequestedSessionId(newRequestedSessionId);
        }
        return requestedSessionId;
    }

    @Override
    public void writeSessionIdWithRoutingInfo(Request request, Response response) {
        String augmentedSessionID = this.buildAugmentedSessionId(request, this.nodeName);
        if (null == augmentedSessionID) {
            return;
        }
        this.setNewSessionCookie(request, response, augmentedSessionID);
    }

    @Override
    public String transformGlobalSessionIdToSessionId(String sessionId) {
        return sessionId + "." + this.nodeName;
    }

    @Override
    public String transformSessionIdToGlobalSessionId(String id) {
        String globalSessionId = id;
        int index = id.indexOf(".");
        if (0 < index) {
            globalSessionId = id.substring(0, index);
        }
        return globalSessionId;
    }

    protected void setNewSessionCookie(Request request, Response response, String augmentedSessionID) {
        Context context = request.getContext();
        if (context.getCookies()) {
            Cookie newCookie = new Cookie(ApplicationSessionCookieConfig.getSessionCookieName((Context)request.getContext()), augmentedSessionID);
            newCookie.setMaxAge(-1);
            String contextPath = null;
            if (context != null && context.getSessionCookiePath() != null) {
                contextPath = context.getSessionCookiePath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                newCookie.setPath(contextPath);
            } else {
                newCookie.setPath("/");
            }
            if (request.isSecure()) {
                newCookie.setSecure(true);
            }
            response.addCookie(newCookie);
        }
    }

    protected String buildAugmentedSessionId(Request request, String nodeName) {
        Session session = request.getSessionInternal();
        if (null == session) {
            return null;
        }
        String sessionID = session.getId();
        String requestedSessionId = request.getRequestedSessionId();
        if (null != requestedSessionId && requestedSessionId.equals(sessionID)) {
            return null;
        }
        return sessionID;
    }
}

