/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.impl;

import java.security.AccessControlContext;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.geronimo.tomcat.security.jacc.JACCUserIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoIdentityService
implements IdentityService {
    private final Subject defaultSubject;

    public GeronimoIdentityService(Subject defaultSubject) {
        this.defaultSubject = defaultSubject;
    }

    @Override
    public Object associate(UserIdentity userIdentity) {
        Subject subject = userIdentity == null ? this.defaultSubject : userIdentity.getSubject();
        Callers callers = ContextManager.getCallers();
        ContextManager.setCallers((Subject)subject, (Subject)subject);
        return callers;
    }

    @Override
    public void dissociate(Object previous) {
        ContextManager.popCallers((Callers)((Callers)previous));
    }

    @Override
    public UserIdentity newUserIdentity(Subject subject, Principal userPrincipal, List<String> groups) {
        AccessControlContext acc = ContextManager.registerSubjectShort((Subject)subject, (Principal)userPrincipal, groups);
        return new JACCUserIdentity(subject, userPrincipal, groups, acc);
    }
}

