/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication.jaspic;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.IdentityService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicCallbackHandler;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicMessageInfo;

public class JaspicAuthenticator
implements Authenticator {
    private static final String MESSAGE_INFO_KEY = "org.apache.geronimo.tomcat.jaspic.message.info";
    private final ServerAuthConfig serverAuthConfig;
    private final Map authProperties;
    private final Subject serviceSubject;
    private final JaspicCallbackHandler callbackHandler;
    private final IdentityService identityService;

    public JaspicAuthenticator(ServerAuthConfig serverAuthConfig, Map authProperties, Subject serviceSubject, JaspicCallbackHandler callbackHandler, IdentityService identityService) {
        this.serverAuthConfig = serverAuthConfig;
        this.authProperties = authProperties;
        this.serviceSubject = serviceSubject;
        this.callbackHandler = callbackHandler;
        this.identityService = identityService;
    }

    public AuthResult validateRequest(Request request, Response response, boolean isAuthMandatory) throws ServerAuthException {
        try {
            JaspicMessageInfo messageInfo = new JaspicMessageInfo(request, response, isAuthMandatory);
            request.setNote(MESSAGE_INFO_KEY, (Object)messageInfo);
            String authContextId = this.serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this.serverAuthConfig.getAuthContext(authContextId, this.serviceSubject, this.authProperties);
            Subject clientSubject = new Subject();
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject, this.serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null);
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null);
            }
            if (authStatus == AuthStatus.SUCCESS) {
                UserIdentity userIdentity;
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (ids.size() > 0) {
                    userIdentity = ids.iterator().next();
                } else {
                    GroupPrincipalCallback groupPrincipalCallback;
                    CallerPrincipalCallback principalCallback = this.callbackHandler.getThreadCallerPrincipalCallback();
                    if (principalCallback == null) {
                        throw new NullPointerException("No CallerPrincipalCallback");
                    }
                    Principal principal = principalCallback.getPrincipal();
                    if (principal == null) {
                        String principalName = principalCallback.getName();
                        Set<Principal> principals = principalCallback.getSubject().getPrincipals();
                        for (Principal p : principals) {
                            if (!p.getName().equals(principalName)) continue;
                            principal = p;
                            break;
                        }
                        if (principal == null) {
                            return new AuthResult(TomcatAuthStatus.SUCCESS, null);
                        }
                    }
                    String[] groups = (groupPrincipalCallback = this.callbackHandler.getThreadGroupPrincipalCallback()) == null ? null : groupPrincipalCallback.getGroups();
                    userIdentity = this.identityService.newUserIdentity(clientSubject, principal, Arrays.asList(groups));
                }
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return new AuthResult(TomcatAuthStatus.SEND_SUCCESS, null);
            }
            throw new NullPointerException("No AuthStatus returned");
        }
        catch (AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        JaspicMessageInfo messageInfo = (JaspicMessageInfo)request.getNote(MESSAGE_INFO_KEY);
        if (messageInfo == null) {
            throw new NullPointerException("MeesageInfo from request missing: " + request);
        }
        try {
            String authContextId = this.serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this.serverAuthConfig.getAuthContext(authContextId, this.serviceSubject, this.authProperties);
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this.serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    public String getAuthType() {
        return "JASPIC";
    }
}

