/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;

public class ClientCertAuthenticator
implements Authenticator {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    private final LoginService loginService;
    private final UserIdentity unauthenticatedIdentity;

    public ClientCertAuthenticator(LoginService loginService, UserIdentity unauthenticatedIdentity) {
        this.loginService = loginService;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    public AuthResult validateRequest(Request request, Response response, boolean isAuthMandatory) throws ServerAuthException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        try {
            if (certs == null || certs.length < 1) {
                if (isAuthMandatory) {
                    response.sendError(400, sm.getString("authenticator.certificates"));
                    return new AuthResult(TomcatAuthStatus.SEND_FAILURE, null);
                }
                return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity);
            }
            UserIdentity userIdentity = this.loginService.login(certs);
            if (userIdentity != null) {
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity);
            }
            if (isAuthMandatory) {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null);
            }
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
        return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity);
    }

    public boolean secureResponse(Request request, Response response, AuthResult authResult) throws ServerAuthException {
        return true;
    }

    public String getAuthType() {
        return "CLIENT-CERT";
    }
}

