/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="TomcatValve")
public class ValveGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(ValveGBean.class);
    public static final String J2EE_TYPE = "TomcatValve";
    private Valve valve;
    private ValveGBean nextValve;
    private String className;

    public ValveGBean() {
        this.valve = null;
        this.nextValve = null;
        this.className = null;
    }

    public ValveGBean(@ParamReference(name="Server") TomcatServerGBean server, @ParamAttribute(name="serviceName") String serviceName, @ParamAttribute(name="containerName") String containerName, @ParamAttribute(name="seq") int seq, @ParamAttribute(name="className") String className, @ParamAttribute(name="initParams") Map<String, String> initParams, @ParamReference(name="NextValve", namingType="TomcatValve") ValveGBean nextValve, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) throws Exception {
        if (server != null) {
            Service service = server.getService(serviceName);
            Container targetContainer = null;
            Container engine = service.getContainer();
            targetContainer = engine.getName().equals(containerName) ? engine : engine.findChild(containerName);
            if (targetContainer == null) {
                log.warn("Could not find the container named [" + containerName + "] in the service [" + serviceName + "]");
                return;
            }
            Valve targetValve = this.findValve(targetContainer, seq);
            if (targetValve == null) {
                log.warn("Could not find the container named [" + containerName + "] with sequence [" + seq + "] in the service [" + serviceName + "]");
                return;
            }
            this.valve = targetValve;
        } else {
            if (className == null) {
                throw new IllegalArgumentException("className cannot be null.");
            }
            if (nextValve != null) {
                if (!(nextValve.getInternalObject() instanceof Valve)) {
                    throw new IllegalArgumentException("The class given as the NextValve attribute does not wrap an object of org.apache.catalina.Valve type.");
                }
                this.nextValve = nextValve;
            } else {
                this.nextValve = null;
            }
            this.className = className;
            this.valve = (Valve)classLoader.loadClass(className).newInstance();
            this.setParameters(this.valve, initParams);
        }
    }

    private Valve findValve(Container container, int seq) {
        Pipeline pipeline = container.getPipeline();
        if (pipeline == null) {
            return null;
        }
        Valve[] valves = pipeline.getValves();
        if (valves == null || seq >= valves.length) {
            return null;
        }
        return valves[seq];
    }

    public void doStart() throws Exception {
        if (this.className != null) {
            log.debug(this.className + " started.");
        }
    }

    public void doStop() throws Exception {
        if (this.className != null) {
            log.debug(this.className + " stopped.");
        }
    }

    public void doFail() {
        if (this.className != null) {
            log.debug(this.className + " failed.");
        }
    }

    @Override
    public Object getInternalObject() {
        return this.valve;
    }

    public ValveGBean getNextValve() {
        return this.nextValve;
    }
}

