/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.geronimo.tomcat.model.MemberType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="InterceptorType")
public class InterceptorType {
    @XmlAttribute
    protected String className;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    @XmlElement(name="Member")
    protected List<MemberType> member;

    public String getClassName() {
        return this.className;
    }

    public ChannelInterceptor getInterceptor(ClassLoader cl) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        ChannelInterceptor channelInterceptor = (ChannelInterceptor)recipe.create(cl);
        if (channelInterceptor instanceof StaticMembershipInterceptor && this.getMember().size() > 0) {
            StaticMembershipInterceptor staticMembershipInterceptor = (StaticMembershipInterceptor)channelInterceptor;
            for (MemberType memberType : this.getMember()) {
                staticMembershipInterceptor.addStaticMember(memberType.getMember(cl));
            }
        }
        return channelInterceptor;
    }

    public List<MemberType> getMember() {
        if (this.member == null) {
            this.member = new ArrayList<MemberType>();
        }
        return this.member;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

