/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.Cluster;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.geronimo.tomcat.model.ClusterType;
import org.apache.geronimo.tomcat.model.ContextType;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.geronimo.tomcat.model.RealmType;
import org.apache.geronimo.tomcat.model.ValveType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="HostType", propOrder={"alias", "cluster", "listener", "realm", "valve", "context"})
public class HostType {
    @XmlElement(name="Alias")
    protected List<String> alias;
    @XmlElement(name="Cluster")
    protected ClusterType cluster;
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlElement(name="Realm")
    protected RealmType realm;
    @XmlElement(name="Valve")
    protected List<ValveType> valve;
    @XmlElement(name="Context")
    protected List<ContextType> context;
    @XmlAttribute
    protected String className = StandardHost.class.getName();
    @XmlAttribute
    protected String name;
    @XmlAttribute
    protected String appBase;
    @XmlAttribute
    protected String hostConfigClass;
    @XmlAttribute
    protected Boolean unpackWARs;
    @XmlAttribute
    protected Boolean autoDeploy;
    @XmlAttribute
    protected Boolean deployOnStartup;
    @XmlAttribute
    protected Boolean xmlValidation;
    @XmlAttribute
    protected Boolean xmlNamespaceAware;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<String> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<String>();
        }
        return this.alias;
    }

    public ClusterType getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterType value) {
        this.cluster = value;
    }

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public RealmType getRealm() {
        return this.realm;
    }

    public void setRealm(RealmType value) {
        this.realm = value;
    }

    public List<ValveType> getValve() {
        if (this.valve == null) {
            this.valve = new ArrayList<ValveType>();
        }
        return this.valve;
    }

    public List<ContextType> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<ContextType>();
        }
        return this.context;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String value) {
        this.appBase = value;
    }

    public String getHostConfigClass() {
        return this.hostConfigClass;
    }

    public void setHostConfigClass(String value) {
        this.hostConfigClass = value;
    }

    public Boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(Boolean value) {
        this.unpackWARs = value;
    }

    public Boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(Boolean value) {
        this.autoDeploy = value;
    }

    public Boolean isDeployOnStartup() {
        return this.deployOnStartup;
    }

    public void setDeployOnStartup(Boolean value) {
        this.deployOnStartup = value;
    }

    public Boolean isXmlValidation() {
        return this.xmlValidation;
    }

    public void setXmlValidation(Boolean value) {
        this.xmlValidation = value;
    }

    public Boolean isXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(Boolean value) {
        this.xmlNamespaceAware = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Host getHost(ClassLoader cl) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", this.getName());
        properties.put("appBase", this.getAppBase());
        properties.put("hostConfigClass", this.getHostConfigClass());
        properties.put("unpackWars", this.isUnpackWARs());
        properties.put("autoDeploy", this.isAutoDeploy());
        properties.put("deployOnStartup", this.isDeployOnStartup());
        properties.put("xmlValidation", this.isXmlValidation());
        properties.put("xmlNamespaceAware", this.isXmlNamespaceAware());
        if (this.getCluster() != null) {
            ClusterType clusterType = this.getCluster();
            Cluster cluster = clusterType.getCluster(cl);
            properties.put("cluster", cluster);
        }
        if (this.getRealm() != null) {
            Realm realm = this.getRealm().getRealm(cl);
            properties.put("realm", realm);
        }
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Host host = (Host)recipe.create(cl);
        if (host instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)host;
            for (ListenerType listenerType : this.getListener()) {
                LifecycleListener listener = listenerType.getLifecycleListener(cl);
                lifecycle.addLifecycleListener(listener);
            }
        }
        for (String alias : this.getAlias()) {
            host.addAlias(alias);
        }
        if (host instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)host;
            for (ValveType valveType : this.getValve()) {
                Valve valve = valveType.getValve(cl);
                pipeline.addValve(valve);
            }
        }
        return host;
    }
}

