/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.net.InetAddress;
import java.util.Set;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.connector.AJP13ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11APRConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11NIOConnectorGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ConnectorWrapperGBeanStarter
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ConnectorWrapperGBeanStarter.class);
    private final TomcatServerGBean server;
    private final TomcatContainer container;
    private final ClassLoader classLoader;
    private final Kernel kernel;

    public ConnectorWrapperGBeanStarter(@ParamReference(name="Server") TomcatServerGBean server, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws Exception {
        this.server = server;
        this.container = container;
        this.classLoader = classLoader;
        this.kernel = kernel;
    }

    private void buildConnectorGBean(ClassLoader cl, Kernel kernel, Connector conn, TomcatContainer container) {
        GBeanInfo gbeanInfo = this.getConnectorGBeanInfo(conn);
        String uniqueName = TomcatServerGBean.ConnectorName.get(conn);
        if (uniqueName == null) {
            return;
        }
        AbstractName containerAbstractName = kernel.getAbstractNameFor((Object)container);
        AbstractName name = kernel.getNaming().createSiblingName(containerAbstractName, uniqueName, "GBean");
        this.server.getService(null);
        GBeanData gbeanData = new GBeanData(name, gbeanInfo);
        gbeanData.setAttribute("name", (Object)uniqueName);
        gbeanData.setAttribute("connector", (Object)conn);
        Object addressProperty = conn.getAttribute("address");
        if (addressProperty != null) {
            gbeanData.setAttribute("host", (Object)(addressProperty instanceof InetAddress ? ((InetAddress)addressProperty).getHostAddress() : addressProperty.toString()));
        }
        gbeanData.setAttribute("port", (Object)conn.getPort());
        gbeanData.setReferencePattern("TomcatContainer", containerAbstractName);
        AbstractNameQuery query = new AbstractNameQuery(ServerInfo.class.getName());
        Set set = kernel.listGBeans(query);
        gbeanData.setReferencePattern("ServerInfo", (AbstractName)set.iterator().next());
        try {
            kernel.loadGBean(gbeanData, cl);
            kernel.startGBean(name);
        }
        catch (Exception e) {
            log.error("Error when building connectorGbean for connector: " + conn.getAttribute("address") + ":" + conn.getPort(), (Throwable)e);
        }
    }

    private GBeanInfo getConnectorGBeanInfo(Connector conn) {
        String className = conn.getProtocolHandlerClassName();
        AnnotationGBeanInfoFactory annotationGbeanInfoFactory = new AnnotationGBeanInfoFactory();
        if (className.equalsIgnoreCase("org.apache.coyote.http11.Http11Protocol")) {
            if (conn.getScheme().equalsIgnoreCase("https")) {
                return annotationGbeanInfoFactory.getGBeanInfo(Https11ConnectorGBean.class);
            }
            return annotationGbeanInfoFactory.getGBeanInfo(Http11ConnectorGBean.class);
        }
        if (className.equalsIgnoreCase("org.apache.coyote.http11.Http11NioProtocol")) {
            if (conn.getScheme().equalsIgnoreCase("https")) {
                return annotationGbeanInfoFactory.getGBeanInfo(Https11NIOConnectorGBean.class);
            }
            return annotationGbeanInfoFactory.getGBeanInfo(Http11NIOConnectorGBean.class);
        }
        if (className.equalsIgnoreCase("org.apache.coyote.ajp.AjpAprProtocol")) {
            return annotationGbeanInfoFactory.getGBeanInfo(AJP13ConnectorGBean.class);
        }
        if (className.equalsIgnoreCase("org.apache.jk.server.JkCoyoteHandler")) {
            return annotationGbeanInfoFactory.getGBeanInfo(AJP13ConnectorGBean.class);
        }
        if (className.equalsIgnoreCase("org.apache.coyote.http11.Http11AprProtocol")) {
            if (conn.getScheme().equalsIgnoreCase("https")) {
                return annotationGbeanInfoFactory.getGBeanInfo(Https11APRConnectorGBean.class);
            }
            return annotationGbeanInfoFactory.getGBeanInfo(Http11APRConnectorGBean.class);
        }
        return null;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        Connector[] connectors;
        for (Connector conn : connectors = this.server.getService(null).findConnectors()) {
            this.buildConnectorGBean(this.classLoader, this.kernel, conn, this.container);
        }
    }

    public void doStop() throws Exception {
    }
}

