/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.realm;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.JAASRealm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.realm.providers.CertificateChainCallbackHandler;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;
import org.apache.geronimo.security.realm.providers.RequestCallbackHandler;
import org.apache.geronimo.tomcat.JAASTomcatPrincipal;

public class TomcatGeronimoRealm
extends JAASRealm {
    private static final Log log = LogFactory.getLog(TomcatGeronimoRealm.class);
    private static ThreadLocal<String> currentRequestWrapperName = new ThreadLocal();
    protected static final String info = "org.apache.geronimo.tomcat.TomcatGeronimoRealm/1.0";
    protected static final String name = "TomcatGeronimoRealm";

    public static String setRequestWrapperName(String requestWrapperName) {
        String old = currentRequestWrapperName.get();
        currentRequestWrapperName.set(requestWrapperName);
        return old;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (PolicyContextException e) {
            log.error((Object)e);
        }
        if (subject == null) {
            return super.hasUserDataPermission(request, response, constraints);
        }
        ContextManager.setCallers((Subject)subject, (Subject)subject);
        try {
            AccessControlContext acc = ContextManager.getCurrentContext();
            WebUserDataPermission wudp = new WebUserDataPermission((HttpServletRequest)request);
            acc.checkPermission((Permission)wudp);
        }
        catch (AccessControlException ace) {
            response.sendError(403);
            return false;
        }
        return true;
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getDecodedRequestURI();
            String loginPage = context.getPath() + config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to login page " + loginPage));
                }
                return true;
            }
            String errorPage = context.getPath() + config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to error page " + errorPage));
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Allow access to username/password submission");
                }
                return true;
            }
        }
        currentRequestWrapperName.set(request.getWrapper().getName());
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            Subject defaultSubject = (Subject)request.getAttribute("~DEFAULT_SUBJECT");
            ContextManager.setCallers((Subject)defaultSubject, (Subject)defaultSubject);
        } else {
            Subject currentCaller = ((JAASTomcatPrincipal)principal).getSubject();
            ContextManager.setCallers((Subject)currentCaller, (Subject)currentCaller);
        }
        try {
            AccessControlContext acc = ContextManager.getCurrentContext();
            acc.checkPermission((Permission)new WebResourcePermission((HttpServletRequest)request));
        }
        catch (AccessControlException ace) {
            response.sendError(403);
            return false;
        }
        return true;
    }

    public boolean hasRole(Principal principal, String role) {
        String name = currentRequestWrapperName.get();
        if (name == null || name.equals("jsp")) {
            name = "";
        }
        AccessControlContext acc = ContextManager.getCurrentContext();
        try {
            acc.checkPermission((Permission)new WebRoleRefPermission(name, role));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public Principal authenticate(String username, String credentials) {
        char[] cred = credentials == null ? null : credentials.toCharArray();
        PasswordCallbackHandler callbackHandler = new PasswordCallbackHandler(username, cred);
        return this.authenticate((CallbackHandler)callbackHandler, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(HttpServletRequest httpRequest) {
        if (httpRequest == null) {
            return null;
        }
        RequestCallbackHandler callbackHandler = new RequestCallbackHandler(httpRequest);
        String hostName = httpRequest.getRemoteHost();
        try {
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("JAASRealm login requested for host {0} using LoginContext for application {1} ", hostName, this.appName));
            }
            ClassLoader ocl = null;
            if (this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
            try {
                loginContext = ContextManager.login((String)this.appName, (CallbackHandler)callbackHandler);
            }
            catch (AccountExpiredException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("Host {0} NOT authenticated due to expired account", hostName), (Throwable)e);
                }
                Principal principal = null;
                return principal;
            }
            catch (CredentialExpiredException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("Host {0} NOT authenticated due to expired credential", hostName), (Throwable)e);
                }
                Principal principal = null;
                return principal;
            }
            catch (FailedLoginException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("Host {0} NOT authenticated due to failed login", hostName), (Throwable)e);
                }
                Principal principal = null;
                return principal;
            }
            catch (LoginException e) {
                log.warn((Object)MessageFormat.format("Login exception authenticating host {0} with the following exception ", hostName), (Throwable)e);
                Principal principal = null;
                return principal;
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                Principal principal = null;
                return principal;
            }
            finally {
                if (this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(ocl);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login context created for host " + hostName));
            }
            Subject subject = loginContext.getSubject();
            ContextManager.setCallers((Subject)subject, (Subject)subject);
            String principal = subject.getPublicCredentials().iterator().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jaasRealm.loginContextCreated", (Object)principal));
            }
            JAASTomcatPrincipal jaasPrincipal = new JAASTomcatPrincipal(principal);
            jaasPrincipal.setSubject(subject);
            return jaasPrincipal;
        }
        catch (Throwable t) {
            log.error((Object)"error ", t);
            return null;
        }
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return null;
        }
        CertificateChainCallbackHandler callbackHandler = new CertificateChainCallbackHandler((Certificate[])certs);
        String principalName = certs[0].getSubjectX500Principal().getName();
        return this.authenticate((CallbackHandler)callbackHandler, principalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(CallbackHandler callbackHandler, String principalName) {
        try {
            if (principalName != null && !principalName.equals("")) {
                LoginContext loginContext = null;
                if (this.appName == null) {
                    this.appName = "Tomcat";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.beginLogin", (Object)principalName, (Object)this.appName));
                }
                ClassLoader ocl = null;
                if (this.isUseContextClassLoader()) {
                    ocl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                }
                try {
                    loginContext = ContextManager.login((String)this.appName, (CallbackHandler)callbackHandler);
                }
                catch (AccountExpiredException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("jaasRealm.accountExpired", (Object)principalName));
                    }
                    Principal principal = null;
                    return principal;
                }
                catch (CredentialExpiredException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("jaasRealm.credentialExpired", (Object)principalName));
                    }
                    Principal principal = null;
                    return principal;
                }
                catch (FailedLoginException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("jaasRealm.failedLogin", (Object)principalName));
                    }
                    Principal principal = null;
                    return principal;
                }
                catch (LoginException e) {
                    log.warn((Object)sm.getString("jaasRealm.loginException", (Object)principalName), (Throwable)e);
                    Principal principal = null;
                    return principal;
                }
                catch (Throwable e) {
                    log.error((Object)sm.getString("jaasRealm.unexpectedError"), e);
                    Principal principal = null;
                    return principal;
                }
                finally {
                    if (this.isUseContextClassLoader()) {
                        Thread.currentThread().setContextClassLoader(ocl);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Login context created " + principalName));
                }
                Subject subject = loginContext.getSubject();
                ContextManager.setCallers((Subject)subject, (Subject)subject);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jaasRealm.loginContextCreated", (Object)principalName));
                }
                JAASTomcatPrincipal jaasPrincipal = new JAASTomcatPrincipal(principalName);
                jaasPrincipal.setSubject(subject);
                return jaasPrincipal;
            }
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)"Login Failed - null userID");
            return null;
        }
        catch (Throwable t) {
            log.error((Object)"error ", t);
            return null;
        }
    }

    public void start() throws LifecycleException {
        super.start();
        this.setUseContextClassLoader(false);
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

