/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class SpnegoAuthenticator
extends AuthenticatorBase {
    private static Log log = LogFactory.getLog(SpnegoAuthenticator.class);
    private static final String SPNEGO_METHOD = "SPNEGO";
    public static final byte[] AUTHENTICATE_BYTES = new byte[]{87, 87, 87, 45, 65, 117, 116, 104, 101, 110, 116, 105, 99, 97, 116, 101};

    protected boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        HttpServletResponse httpResponse = response.getResponse();
        HttpServletRequest httpRequest = request.getRequest();
        String header = httpRequest.getHeader("Authorization");
        if (header == null) {
            httpResponse.setHeader("WWW-Authenticate", "Negotiate");
            httpResponse.setStatus(401);
            return false;
        }
        if (header != null && header.startsWith("Negotiate")) {
            Principal principal = request.getUserPrincipal();
            String username = header.substring(10);
            String password = null;
            principal = this.context.getRealm().authenticate(username, password);
            if (principal != null) {
                this.register(request, response, principal, SPNEGO_METHOD, username, password);
                return true;
            }
            request.getCoyoteRequest().getMimeHeaders().removeHeader("authorization");
        }
        String username = null;
        String password = null;
        Principal principal = request.getUserPrincipal();
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization != null) {
            authorization.toBytes();
            ByteChunk authorizationBC = authorization.getByteChunk();
            if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
                authorizationBC.setOffset(authorizationBC.getOffset() + 6);
                CharChunk authorizationCC = authorization.getCharChunk();
                Base64.decode((ByteChunk)authorizationBC, (CharChunk)authorizationCC);
                int colon = authorizationCC.indexOf(':');
                if (colon < 0) {
                    username = authorizationCC.toString();
                } else {
                    char[] buf = authorizationCC.getBuffer();
                    username = new String(buf, 0, colon);
                    password = new String(buf, colon + 1, authorizationCC.getEnd() - colon - 1);
                }
                authorizationBC.setOffset(authorizationBC.getOffset() - 6);
            }
            if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                this.register(request, response, principal, SPNEGO_METHOD, username, password);
                return true;
            }
        }
        MessageBytes authenticate = response.getCoyoteResponse().getMimeHeaders().addValue(AUTHENTICATE_BYTES, 0, AUTHENTICATE_BYTES.length);
        CharChunk authenticateCC = authenticate.getCharChunk();
        authenticateCC.append("Basic realm=\"");
        if (config.getRealmName() == null) {
            authenticateCC.append(request.getServerName());
            authenticateCC.append(':');
            authenticateCC.append(Integer.toString(request.getServerPort()));
        } else {
            authenticateCC.append(config.getRealmName());
        }
        authenticateCC.append('\"');
        authenticate.toChars();
        response.sendError(401);
        return false;
    }
}

