/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;

public class PolicyContextBeforeAfter
implements BeforeAfter {
    public static final String DEFAULT_SUBJECT = "~DEFAULT_SUBJECT";
    private final BeforeAfter next;
    private final String policyContextID;
    private final int policyContextIDIndex;
    private final int callersIndex;
    private final int defaultSubjectIndex;
    private final Subject defaultSubject;

    public PolicyContextBeforeAfter(BeforeAfter next, int policyContextIDIndex, int callersIndex, int defaultSubjectIndex, String policyContextID, Subject defaultSubject) {
        this.next = next;
        this.policyContextIDIndex = policyContextIDIndex;
        this.callersIndex = callersIndex;
        this.defaultSubjectIndex = defaultSubjectIndex;
        this.policyContextID = policyContextID;
        this.defaultSubject = defaultSubject;
    }

    public void before(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        context[this.policyContextIDIndex] = PolicyContext.getContextID();
        context[this.callersIndex] = ContextManager.getCallers();
        PolicyContext.setContextID((String)this.policyContextID);
        PolicyContext.setHandlerData((Object)httpRequest);
        if (httpRequest != null) {
            context[this.defaultSubjectIndex] = httpRequest.getAttribute(DEFAULT_SUBJECT);
            httpRequest.setAttribute(DEFAULT_SUBJECT, (Object)this.defaultSubject);
        }
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse, dispatch);
        }
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse, dispatch);
        }
        PolicyContext.setContextID((String)((String)context[this.policyContextIDIndex]));
        PolicyContext.setHandlerData(null);
        ContextManager.popCallers((Callers)((Callers)context[this.callersIndex]));
        if (httpRequest != null) {
            httpRequest.setAttribute(DEFAULT_SUBJECT, context[this.defaultSubjectIndex]);
        }
    }
}

