/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import org.apache.catalina.ha.deploy.FarmWarDeployer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.cluster.ClusterDeployerGBean;

public class FarmWarDeployerGBean
extends ClusterDeployerGBean {
    private static final Log log = LogFactory.getLog(FarmWarDeployerGBean.class);
    private final ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    public FarmWarDeployerGBean() {
        this.serverInfo = null;
    }

    public FarmWarDeployerGBean(String tempDir, String deployDir, String watchDir, boolean watchEnabled, int processDeployFrequency, ServerInfo serverInfo) throws Exception {
        super("org.apache.catalina.ha.deploy.FarmWarDeployer", null);
        if (serverInfo == null) {
            throw new IllegalArgumentException("serverInfo cannot be null.");
        }
        this.serverInfo = serverInfo;
        FarmWarDeployer farm = (FarmWarDeployer)this.deployer;
        if (tempDir == null) {
            tempDir = "var/catalina/war-temp";
        }
        farm.setTempDir(serverInfo.resolvePath(tempDir));
        if (deployDir == null) {
            deployDir = "var/catalina/war-deploy";
        }
        farm.setDeployDir(serverInfo.resolvePath(deployDir));
        if (watchDir == null) {
            watchDir = "var/catalina/war-listen";
        }
        farm.setWatchDir(serverInfo.resolvePath(watchDir));
        farm.setWatchEnabled(watchEnabled);
        farm.setProcessDeployFrequency(processDeployFrequency);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"ClusterDeployer", FarmWarDeployerGBean.class, (GBeanInfo)ClusterDeployerGBean.GBEAN_INFO);
        infoFactory.addAttribute("tempDir", String.class, true);
        infoFactory.addAttribute("deployDir", String.class, true);
        infoFactory.addAttribute("watchDir", String.class, true);
        infoFactory.addAttribute("watchEnabled", Boolean.TYPE, true);
        infoFactory.addAttribute("processDeployFrequency", Integer.TYPE, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.setConstructor(new String[]{"tempDir", "deployDir", "watchDir", "watchEnabled", "processDeployFrequency", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

