/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.catalina.Container;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.GeronimoStandardContext;

public class RunAsInstanceListener
implements InstanceListener {
    private static final ThreadLocal<List<Callers>> threadLocal = new ThreadLocal<List<Callers>>(){

        @Override
        protected List<Callers> initialValue() {
            return new ArrayList<Callers>(2);
        }
    };

    public void instanceEvent(InstanceEvent event) {
        List<Callers> callersStack;
        Callers oldCallers;
        if (event.getType().equals("beforeService")) {
            Container parent = event.getWrapper().getParent();
            if (parent instanceof GeronimoStandardContext) {
                GeronimoStandardContext context = (GeronimoStandardContext)parent;
                Wrapper wrapper = event.getWrapper();
                String runAsRole = wrapper.getRunAs();
                Subject runAsSubject = context.getSubjectForRole(runAsRole);
                List<Callers> callersStack2 = threadLocal.get();
                if (runAsSubject != null) {
                    Callers oldCallers2 = ContextManager.pushNextCaller((Subject)runAsSubject);
                    callersStack2.add(oldCallers2);
                } else {
                    callersStack2.add(null);
                }
            }
        } else if (event.getType().equals("afterService") && (oldCallers = (callersStack = threadLocal.get()).remove(callersStack.size() - 1)) != null) {
            ContextManager.popCallers((Callers)oldCallers);
        }
    }
}

