/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.naming.directory.DirContext;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.InstanceManager;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.RuntimeCustomizer;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.LifecycleListenerGBean;
import org.apache.geronimo.tomcat.ManagerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatInstanceManager;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;
import org.apache.geronimo.tomcat.stats.ModuleStats;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;

public class TomcatWebAppContext
implements GBeanLifecycle,
TomcatContext,
WebModule,
StatisticsProvider {
    private static Log log = LogFactory.getLog(TomcatWebAppContext.class);
    protected final TomcatContainer container;
    private final ClassLoader classLoader;
    protected Context context = null;
    private String path = null;
    private String docBase = null;
    private String virtualServer = null;
    private final Realm realm;
    private final List valveChain;
    private final List listenerChain;
    private final CatalinaCluster catalinaCluster;
    private final Manager manager;
    private final boolean crossContext;
    private final boolean disableCookies;
    private final UserTransaction userTransaction;
    private final javax.naming.Context componentContext;
    private final Kernel kernel;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final SecurityHolder securityHolder;
    private final RunAsSource runAsSource;
    private final J2EEServer server;
    private final Map webServices;
    private final String objectName;
    private final String originalSpecDD;
    private final URL configurationBaseURL;
    private final Holder holder;
    private final RuntimeCustomizer contextCustomizer;
    private final String j2EEServer;
    private final String j2EEApplication;
    private ModuleStats statsProvider;
    private boolean reset = true;
    public static final GBeanInfo GBEAN_INFO;

    public TomcatWebAppContext(ClassLoader classLoader, String objectName, String originalSpecDD, URL configurationBaseUrl, SecurityHolder securityHolder, String virtualServer, Map componentContext, Set unshareableResources, Set applicationManagedSecurityResources, TransactionManager transactionManager, TrackedConnectionAssociator trackedConnectionAssociator, TomcatContainer container, RunAsSource runAsSource, ObjectRetriever tomcatRealm, ValveGBean tomcatValveChain, LifecycleListenerGBean lifecycleListenerChain, CatalinaClusterGBean cluster, ManagerGBean manager, boolean crossContext, boolean disableCookies, Map webServices, Holder holder, RuntimeCustomizer contextCustomizer, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception {
        ArrayList<Object> chain;
        assert (classLoader != null);
        assert (configurationBaseUrl != null);
        assert (transactionManager != null);
        assert (trackedConnectionAssociator != null);
        assert (componentContext != null);
        assert (container != null);
        this.objectName = objectName;
        URI root = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        this.setDocBase(root.getPath());
        this.container = container;
        this.originalSpecDD = originalSpecDD;
        this.virtualServer = virtualServer;
        this.securityHolder = securityHolder;
        this.userTransaction = new GeronimoUserTransaction(transactionManager);
        this.componentContext = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)this.userTransaction, (Kernel)kernel, (ClassLoader)classLoader);
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.server = server;
        RunAsSource runAsSource2 = this.runAsSource = runAsSource == null ? RunAsSource.NULL : runAsSource;
        if (securityHolder != null) {
            securityHolder.setDefaultSubject(this.runAsSource.getDefaultSubject());
            securityHolder.setRunAsSource(this.runAsSource);
        }
        this.configurationBaseURL = configurationBaseUrl;
        this.holder = holder == null ? new Holder() : holder;
        this.contextCustomizer = contextCustomizer;
        if (tomcatRealm != null) {
            this.realm = (Realm)tomcatRealm.getInternalObject();
            if (this.realm == null) {
                throw new IllegalArgumentException("tomcatRealm must be an instance of org.apache.catalina.Realm.");
            }
        } else {
            this.realm = null;
        }
        if (tomcatValveChain != null) {
            chain = new ArrayList<Object>();
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                chain.add((Valve)valveGBean.getInternalObject());
            }
            this.valveChain = chain;
        } else {
            this.valveChain = null;
        }
        if (lifecycleListenerChain != null) {
            chain = new ArrayList();
            for (LifecycleListenerGBean listenerGBean = lifecycleListenerChain; listenerGBean != null; listenerGBean = listenerGBean.getNextListener()) {
                chain.add((LifecycleListener)listenerGBean.getInternalObject());
            }
            this.listenerChain = chain;
        } else {
            this.listenerChain = null;
        }
        this.catalinaCluster = cluster != null ? (CatalinaCluster)cluster.getInternalObject() : null;
        this.manager = manager != null ? (Manager)manager.getInternalObject() : null;
        this.crossContext = crossContext;
        this.disableCookies = disableCookies;
        this.webServices = this.createWebServices(webServices, kernel);
        this.classLoader = classLoader;
        this.kernel = kernel;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
            this.j2EEServer = myObjectName.getKeyProperty("J2EEServer");
            this.j2EEApplication = myObjectName.getKeyProperty("J2EEApplication");
        } else {
            this.j2EEServer = null;
            this.j2EEApplication = null;
        }
    }

    private Map createWebServices(Map webServiceFactoryMap, Kernel kernel) throws Exception {
        HashMap<String, WebServiceContainer> webServices = new HashMap<String, WebServiceContainer>();
        if (webServiceFactoryMap != null) {
            for (Map.Entry entry : webServiceFactoryMap.entrySet()) {
                String servletName = (String)entry.getKey();
                AbstractName factoryName = (AbstractName)entry.getValue();
                WebServiceContainerFactory webServiceContainerFactory = (WebServiceContainerFactory)kernel.getGBean(factoryName);
                WebServiceContainer webServiceContainer = webServiceContainerFactory.getWebServiceContainer();
                webServices.put(servletName, webServiceContainer);
            }
        }
        return webServices;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public URL getWARDirectory() {
        return this.configurationBaseURL;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.container;
    }

    public String getServer() {
        return this.server == null ? null : this.server.getObjectName();
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public javax.naming.Context getJndiContext() {
        return this.componentContext;
    }

    public String getVirtualServer() {
        return this.virtualServer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public boolean isDisableCookies() {
        return this.disableCookies;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.path;
    }

    public void setContextPath(String path) {
        this.path = path.startsWith("/") ? path : "/" + path;
    }

    public SecurityHolder getSecurityHolder() {
        return this.securityHolder;
    }

    public Set getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public Set getUnshareableResources() {
        return this.unshareableResources;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List getValveChain() {
        return this.valveChain;
    }

    public List getLifecycleListenerChain() {
        return this.listenerChain;
    }

    public CatalinaCluster getCluster() {
        return this.catalinaCluster;
    }

    public Manager getManager() {
        return this.manager;
    }

    public boolean isCrossContext() {
        return this.crossContext;
    }

    public Map getWebServices() {
        return this.webServices;
    }

    public InstanceManager getInstanceManager() {
        return new TomcatInstanceManager(this.holder, this.classLoader, this.componentContext);
    }

    public RuntimeCustomizer getRuntimeCustomizer() {
        return this.contextCustomizer;
    }

    public String[] getServlets() {
        String[] result = null;
        if (this.context != null && this.context instanceof StandardContext) {
            result = ((StandardContext)this.context).getServlets();
        }
        return result;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public String[] getJavaVMs() {
        return this.server == null ? new String[]{} : this.server.getJavaVMs();
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public Stats getStats() {
        if (this.reset) {
            this.reset = false;
            return this.statsProvider.getStats();
        }
        return this.statsProvider.updateStats();
    }

    public void resetStats() {
        this.reset = true;
    }

    public void doStart() throws Exception {
        this.container.addContext(this);
        DirContext resources = this.context.getResources();
        if (resources == null) {
            throw new IllegalStateException("JNDI environment was not set up correctly due to previous error");
        }
        DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)resources);
        if (this.context instanceof StandardContext) {
            this.statsProvider = new ModuleStats((StandardContext)this.context);
        }
        log.debug((Object)("TomcatWebAppContext started for " + this.path));
    }

    public void doStop() throws Exception {
        this.statsProvider = null;
        this.container.removeContext(this);
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        log.debug((Object)"TomcatWebAppContext stopped");
    }

    public void doFail() {
        this.statsProvider = null;
        this.container.removeContext(this);
        log.warn((Object)"TomcatWebAppContext failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Tomcat WebApplication Context", TomcatWebAppContext.class, (String)"WebModule");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addAttribute("securityHolder", SecurityHolder.class, true);
        infoBuilder.addAttribute("virtualServer", String.class, true);
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "TransactionManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("Container", TomcatContainer.class, "GBean");
        infoBuilder.addReference("RunAsSource", RunAsSource.class, "JACCManager");
        infoBuilder.addReference("TomcatRealm", ObjectRetriever.class);
        infoBuilder.addReference("TomcatValveChain", ValveGBean.class);
        infoBuilder.addReference("LifecycleListenerChain", LifecycleListenerGBean.class, "TomcatLifecycleListener");
        infoBuilder.addReference("Cluster", CatalinaClusterGBean.class, "Cluster");
        infoBuilder.addReference("Manager", ManagerGBean.class);
        infoBuilder.addAttribute("crossContext", Boolean.TYPE, true);
        infoBuilder.addAttribute("disableCookies", Boolean.TYPE, true);
        infoBuilder.addAttribute("webServices", Map.class, true);
        infoBuilder.addAttribute("holder", Holder.class, true);
        infoBuilder.addReference("ContextCustomizer", RuntimeCustomizer.class, "GBean");
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"classLoader", "objectName", "deploymentDescriptor", "configurationBaseUrl", "securityHolder", "virtualServer", "componentContext", "unshareableResources", "applicationManagedSecurityResources", "TransactionManager", "TrackedConnectionAssociator", "Container", "RunAsSource", "TomcatRealm", "TomcatValveChain", "LifecycleListenerChain", "Cluster", "Manager", "crossContext", "disableCookies", "webServices", "holder", "ContextCustomizer", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

