/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.tomcat.cluster.JkRouter;
import org.apache.geronimo.tomcat.cluster.Router;

public class ClusteredManager
extends StandardManager {
    private final SessionManager sessionManager;
    private final String nodeName;
    private final Router router;

    public ClusteredManager(SessionManager sessionManager) {
        if (null == sessionManager) {
            throw new IllegalArgumentException("sessionManager is required");
        }
        this.sessionManager = sessionManager;
        this.nodeName = sessionManager.getNode().getName();
        this.router = this.newRouter(this.nodeName);
        sessionManager.registerListener((SessionListener)new MigrationListener());
    }

    protected Router newRouter(String nodeName) {
        return new JkRouter(nodeName);
    }

    public String getJvmRoute() {
        return this.nodeName;
    }

    public void stop() throws LifecycleException {
        this.lifecycle.fireLifecycleEvent("stop", null);
    }

    public Session createEmptySession() {
        return new ClusteredSession();
    }

    public void backgroundProcess() {
    }

    public class ClusteredSession
    extends StandardSession {
        private org.apache.geronimo.clustering.Session session;

        protected ClusteredSession() {
            super((Manager)ClusteredManager.this);
        }

        protected ClusteredSession(org.apache.geronimo.clustering.Session session) {
            super((Manager)ClusteredManager.this);
            this.session = session;
            this.attributes = session.getState();
            String sessionId = ClusteredManager.this.router.transformGlobalSessionIdToSessionId(session.getSessionId());
            super.setId(sessionId);
            this.setValid(true);
            this.setNew(false);
        }

        public void setId(String id) {
            super.setId(id);
            this.newUnderlyingSession(id);
            this.attributes = this.session.getState();
        }

        protected void newUnderlyingSession(String id) {
            String globalSessionId = ClusteredManager.this.router.transformSessionIdToGlobalSessionId(id);
            try {
                this.session = ClusteredManager.this.sessionManager.createSession(globalSessionId);
            }
            catch (SessionAlreadyExistException e) {
                throw (IllegalStateException)new IllegalStateException().initCause(e);
            }
        }

        public void invalidate() throws IllegalStateException {
            super.invalidate();
            this.session.release();
        }

        public void endAccess() {
            super.endAccess();
            this.session.onEndAccess();
        }
    }

    private class MigrationListener
    implements SessionListener {
        private MigrationListener() {
        }

        public void notifyInboundSessionMigration(org.apache.geronimo.clustering.Session session) {
            ClusteredManager.this.add((Session)new ClusteredSession(session));
        }

        public void notifyOutboundSessionMigration(org.apache.geronimo.clustering.Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            ClusteredManager.this.remove((Session)clusteredSession);
        }

        public void notifySessionDestruction(org.apache.geronimo.clustering.Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            if (null == clusteredSession) {
                return;
            }
            ClusteredManager.this.remove((Session)clusteredSession);
        }

        protected ClusteredSession getClusteredSession(org.apache.geronimo.clustering.Session session) {
            String sessionId = session.getSessionId();
            sessionId = ClusteredManager.this.router.transformGlobalSessionIdToSessionId(sessionId);
            return (ClusteredSession)((Object)ClusteredManager.this.sessions.get(sessionId));
        }
    }
}

