/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.io.IOException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;

public class ClusteredManager
extends StandardManager {
    private final SessionManager sessionManager;

    public ClusteredManager(SessionManager sessionManager) {
        if (null == sessionManager) {
            throw new IllegalArgumentException("sessionManager is required");
        }
        this.sessionManager = sessionManager;
        sessionManager.registerListener((SessionListener)new MigrationListener());
    }

    public Session createEmptySession() {
        return new ClusteredSession();
    }

    protected void doLoad() throws ClassNotFoundException, IOException {
    }

    protected void doUnload() throws IOException {
    }

    public void backgroundProcess() {
    }

    public class ClusteredSession
    extends StandardSession {
        private org.apache.geronimo.clustering.Session session;

        protected ClusteredSession() {
            super((Manager)ClusteredManager.this);
        }

        protected ClusteredSession(org.apache.geronimo.clustering.Session session) {
            super((Manager)ClusteredManager.this);
            this.session = session;
            this.attributes = session.getState();
            super.setId(session.getSessionId());
            this.setValid(true);
            this.setNew(false);
        }

        public void setId(String id) {
            super.setId(id);
            try {
                this.session = ClusteredManager.this.sessionManager.createSession(id);
            }
            catch (SessionAlreadyExistException e) {
                throw (IllegalStateException)new IllegalStateException().initCause(e);
            }
            this.attributes = this.session.getState();
        }

        public void invalidate() throws IllegalStateException {
            super.invalidate();
            this.session.release();
        }

        public void endAccess() {
            super.endAccess();
            this.session.onEndAccess();
        }
    }

    private class MigrationListener
    implements SessionListener {
        private MigrationListener() {
        }

        public void notifyInboundSessionMigration(org.apache.geronimo.clustering.Session session) {
            ClusteredManager.this.add((Session)new ClusteredSession(session));
        }

        public void notifyOutboundSessionMigration(org.apache.geronimo.clustering.Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            ClusteredManager.this.remove((Session)clusteredSession);
        }

        public void notifySessionDestruction(org.apache.geronimo.clustering.Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            ClusteredManager.this.remove((Session)clusteredSession);
        }

        protected ClusteredSession getClusteredSession(org.apache.geronimo.clustering.Session session) {
            return (ClusteredSession)((Object)ClusteredManager.this.sessions.get(session.getSessionId()));
        }
    }
}

