/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster.wadi.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.clustering.wadi.BasicWADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.cluster.ClusteredManagerRetriever;
import org.apache.geronimo.tomcat.cluster.wadi.WADIClusteredValveRetriever;
import org.apache.geronimo.tomcat.cluster.wadi.builder.TomcatClusteringWADIConverter;
import org.apache.geronimo.xbeans.geronimo.GerTomcatClusteringWadiDocument;
import org.apache.geronimo.xbeans.geronimo.GerTomcatClusteringWadiType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class WADITomcatClusteringBuilder
implements NamespaceDrivenBuilder {
    private static final QName CLUSTERING_WADI_QNAME = GerTomcatClusteringWadiDocument.type.getDocumentElementName();
    private static final QNameSet CLUSTERING_WADI_QNAME_SET = QNameSet.singleton((QName)CLUSTERING_WADI_QNAME);
    private final int defaultSweepInterval;
    private final int defaultSessionTimeout;
    private final int defaultNumPartitions;
    private final AbstractNameQuery defaultBackingStrategyFactoryName;
    private final AbstractNameQuery defaultClusterName;
    private final Environment defaultEnvironment;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_DFT_SWEEP_INTERVAL = "defaultSweepInterval";
    public static final String GBEAN_ATTR_DFT_SESSION_TIMEOUT = "defaultSessionTimeout";
    public static final String GBEAN_ATTR_DFT_NUM_PARTITIONS = "defaultNumPartitions";
    public static final String GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME = "defaultBackingStrategyFactoryName";
    public static final String GBEAN_ATTR_DFT_CLUSTER_NAME = "defaultClusterName";
    public static final String GBEAN_ATTR_DFT_ENVIRONMENT = "defaultEnvironment";

    public WADITomcatClusteringBuilder(int defaultSweepInterval, int defaultSessionTimeout, int defaultNumPartitions, AbstractNameQuery defaultBackingStrategyFactoryName, AbstractNameQuery defaultClusterName, Environment defaultEnvironment) {
        if (defaultSweepInterval < 1) {
            throw new IllegalArgumentException("defaultSweepInterval is lower than 1");
        }
        if (defaultSessionTimeout < 1) {
            throw new IllegalArgumentException("defaultSessionTimeout is lower than 1");
        }
        if (defaultNumPartitions < 1) {
            throw new IllegalArgumentException("defaultNumPartitions is lower than 1");
        }
        if (null == defaultBackingStrategyFactoryName) {
            throw new IllegalArgumentException("defaultBackingStrategyFactoryName is required");
        }
        if (null == defaultClusterName) {
            throw new IllegalArgumentException("defaultClusterName is required");
        }
        if (null == defaultEnvironment) {
            throw new IllegalArgumentException("defaultEnvironment is required");
        }
        this.defaultSweepInterval = defaultSweepInterval;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.defaultNumPartitions = defaultNumPartitions;
        this.defaultBackingStrategyFactoryName = defaultBackingStrategyFactoryName;
        this.defaultClusterName = defaultClusterName;
        this.defaultEnvironment = defaultEnvironment;
    }

    public void buildEnvironment(XmlObject container, Environment environment) throws DeploymentException {
        if (this.getWadiClusterConfig(container) != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void build(XmlObject container, DeploymentContext applicationContext, DeploymentContext moduleContext) throws DeploymentException {
        GerTomcatClusteringWadiType clusteringWadiType = this.getWadiClusterConfig(container);
        if (clusteringWadiType != null) {
            GBeanData webModuleData = this.extractWebModule(moduleContext);
            try {
                AbstractName sessionManagerName = this.addSessionManager(clusteringWadiType, webModuleData, moduleContext);
                this.addClusteredManagerRetriever(moduleContext, webModuleData, sessionManagerName);
                this.addClusteredValveRetriever(moduleContext, webModuleData, sessionManagerName);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate GBean", (Throwable)e);
            }
        }
    }

    protected GBeanData extractWebModule(DeploymentContext moduleContext) throws DeploymentException {
        Configuration configuration = moduleContext.getConfiguration();
        AbstractNameQuery webModuleQuery = new AbstractNameQuery(configuration.getId(), Collections.EMPTY_MAP, Collections.singleton(TomcatWebAppContext.class.getName()));
        try {
            return configuration.findGBeanData(webModuleQuery);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Could not locate web module gbean in web app configuration", (Throwable)e);
        }
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return CLUSTERING_WADI_QNAME_SET;
    }

    protected GerTomcatClusteringWadiType getWadiClusterConfig(XmlObject container) throws DeploymentException {
        XmlObject[] items = container.selectChildren(CLUSTERING_WADI_QNAME_SET);
        if (items.length > 1) {
            throw new DeploymentException("Unexpected count of clustering elements in geronimo plan " + items.length + " qnameset: " + CLUSTERING_WADI_QNAME_SET);
        }
        if (items.length == 1) {
            return (GerTomcatClusteringWadiType)items[0].copy().changeType(GerTomcatClusteringWadiType.type);
        }
        return null;
    }

    protected AbstractName addSessionManager(GerTomcatClusteringWadiType clustering, GBeanData webModuleData, DeploymentContext moduleContext) throws GBeanAlreadyExistsException {
        AbstractName name = this.newGBeanName(moduleContext, "WADISessionManager");
        GBeanData beanData = new GBeanData(name, BasicWADISessionManager.GBEAN_INFO);
        this.setConfigInfo(clustering, webModuleData, beanData);
        this.setCluster(clustering, beanData);
        this.setBackingStrategyFactory(clustering, beanData);
        this.addGBean(moduleContext, beanData);
        return name;
    }

    protected void setConfigInfo(GerTomcatClusteringWadiType clustering, GBeanData webModuleData, GBeanData beanData) {
        URI serviceSpaceName;
        int sweepInterval = this.getSweepInterval(clustering);
        int numPartitions = this.getNumberOfPartitions(clustering);
        Integer sessionTimeout = this.getSessionTimeout(webModuleData);
        boolean disableReplication = this.isDisableReplication(clustering);
        boolean deltaReplication = this.isDeltaReplication(clustering);
        String contextPath = (String)webModuleData.getAttribute("contextPath");
        try {
            serviceSpaceName = new URI(contextPath);
        }
        catch (URISyntaxException e) {
            AssertionError error = new AssertionError((Object)("contextPath [" + contextPath + "] cannot be parsed as an URI."));
            throw (AssertionError)((Object)((Throwable)((Object)error)).initCause(e));
        }
        WADISessionManagerConfigInfo configInfo = new WADISessionManagerConfigInfo(serviceSpaceName, sweepInterval, numPartitions, sessionTimeout.intValue(), disableReplication, deltaReplication);
        beanData.setAttribute("wadiConfigInfo", (Object)configInfo);
    }

    protected Integer getSessionTimeout(GBeanData webModuleData) throws AssertionError {
        return this.defaultSessionTimeout;
    }

    protected boolean isDeltaReplication(GerTomcatClusteringWadiType clustering) {
        if (clustering.isSetDeltaReplication()) {
            return clustering.getDeltaReplication();
        }
        return false;
    }

    protected boolean isDisableReplication(GerTomcatClusteringWadiType clustering) {
        if (clustering.isSetDisableReplication()) {
            return clustering.getDisableReplication();
        }
        return false;
    }

    protected int getNumberOfPartitions(GerTomcatClusteringWadiType clustering) {
        if (clustering.isSetNumPartitions()) {
            return clustering.getNumPartitions().intValue();
        }
        return this.defaultNumPartitions;
    }

    protected int getSweepInterval(GerTomcatClusteringWadiType clustering) {
        if (clustering.isSetSweepInterval()) {
            return clustering.getSweepInterval().intValue();
        }
        return this.defaultSweepInterval;
    }

    protected void setCluster(GerTomcatClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetCluster()) {
            this.addAbstractNameQueries(patterns, clustering.getCluster());
        } else {
            patterns.add(this.defaultClusterName);
        }
        beanData.setReferencePatterns("Cluster", patterns);
    }

    protected void setBackingStrategyFactory(GerTomcatClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetBackingStrategyFactory()) {
            this.addAbstractNameQueries(patterns, clustering.getBackingStrategyFactory());
        } else {
            patterns.add(this.defaultBackingStrategyFactoryName);
        }
        beanData.setReferencePatterns("BackingStrategyFactory", patterns);
    }

    protected AbstractName addClusteredValveRetriever(DeploymentContext moduleContext, GBeanData webModuleData, AbstractName sessionManagerName) throws GBeanAlreadyExistsException {
        AbstractName name = this.newGBeanName(moduleContext, "WADIClusteredValveRetriever");
        GBeanData beanData = new GBeanData(name, WADIClusteredValveRetriever.GBEAN_INFO);
        beanData.setReferencePattern("WADISessionManager", sessionManagerName);
        webModuleData.setReferencePattern("ClusteredValveRetriever", name);
        this.addGBean(moduleContext, beanData);
        return name;
    }

    protected AbstractName addClusteredManagerRetriever(DeploymentContext moduleContext, GBeanData webModuleData, AbstractName sessionManagerName) throws GBeanAlreadyExistsException {
        AbstractName name = this.newGBeanName(moduleContext, "ClusteredManagerRetriever");
        GBeanData beanData = new GBeanData(name, ClusteredManagerRetriever.GBEAN_INFO);
        beanData.setReferencePattern("SessionManager", sessionManagerName);
        webModuleData.setReferencePattern("ManagerRetriever", name);
        this.addGBean(moduleContext, beanData);
        return name;
    }

    protected void addGBean(DeploymentContext moduleContext, GBeanData beanData) throws GBeanAlreadyExistsException {
        moduleContext.addGBean(beanData);
    }

    protected AbstractName newGBeanName(DeploymentContext moduleContext, String name) {
        return moduleContext.getNaming().createChildName(moduleContext.getModuleName(), name, "GBean");
    }

    protected void addAbstractNameQueries(Set patterns, GerPatternType patternType) {
        AbstractNameQuery query = ENCConfigBuilder.buildAbstractNameQuery((GerPatternType)patternType, null, null, null);
        patterns.add(query);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(CLUSTERING_WADI_QNAME.getLocalPart(), new TomcatClusteringWADIConverter()));
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI Session Manager", WADITomcatClusteringBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_SWEEP_INTERVAL, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_SESSION_TIMEOUT, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_NUM_PARTITIONS, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME, AbstractNameQuery.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_CLUSTER_NAME, AbstractNameQuery.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_ENVIRONMENT, Environment.class, true);
        infoBuilder.setConstructor(new String[]{GBEAN_ATTR_DFT_SWEEP_INTERVAL, GBEAN_ATTR_DFT_SESSION_TIMEOUT, GBEAN_ATTR_DFT_NUM_PARTITIONS, GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME, GBEAN_ATTR_DFT_CLUSTER_NAME, GBEAN_ATTR_DFT_ENVIRONMENT});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

