/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;

public class PolicyContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final String policyContextID;
    private final int policyContextIDIndex;
    private final int callersIndex;

    public PolicyContextBeforeAfter(BeforeAfter next, int policyContextIDIndex, int callersIndex, String policyContextID) {
        this.next = next;
        this.policyContextIDIndex = policyContextIDIndex;
        this.callersIndex = callersIndex;
        this.policyContextID = policyContextID;
    }

    public void before(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        context[this.policyContextIDIndex] = PolicyContext.getContextID();
        context[this.callersIndex] = ContextManager.getCallers();
        PolicyContext.setContextID((String)this.policyContextID);
        PolicyContext.setHandlerData((Object)httpRequest);
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        PolicyContext.setContextID((String)((String)context[this.policyContextIDIndex]));
        ContextManager.popCallers((Callers)((Callers)context[this.callersIndex]));
    }
}

