/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.TomcatEJBWebServiceContext;
import org.apache.geronimo.webservices.WebServiceContainer;

public class TomcatGeronimoEmbedded
extends Embedded {
    private static final Log log = LogFactory.getLog((Class)TomcatGeronimoEmbedded.class);

    public Context createContext(String path, String docBase, ClassLoader cl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating context '" + path + "' with docBase '" + docBase + "'"));
        }
        GeronimoStandardContext context = new GeronimoStandardContext();
        context.setDocBase(docBase);
        context.setPath(path);
        if (cl != null) {
            context.setParentClassLoader(cl);
        }
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators((Map)this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        context.setDelegate(true);
        return context;
    }

    public Context createEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating EJBWebService context '" + contextPath + "'."));
        }
        TomcatEJBWebServiceContext context = new TomcatEJBWebServiceContext(contextPath, webServiceContainer, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators((Map)this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }
}

