/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.File;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.realm.JAASRealm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatEJBWebServiceContext;
import org.apache.geronimo.tomcat.TomcatGeronimoEmbedded;
import org.apache.geronimo.tomcat.TomcatWebContainer;
import org.apache.geronimo.tomcat.realm.TomcatGeronimoRealm;
import org.apache.geronimo.tomcat.realm.TomcatJAASRealm;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;

public class TomcatContainer
implements SoapHandler,
GBeanLifecycle,
TomcatWebContainer {
    private static final Log log = LogFactory.getLog((Class)TomcatContainer.class);
    private static final String DEFAULT_CATALINA_HOME = "var/catalina";
    private TomcatGeronimoEmbedded embedded;
    private Engine engine;
    private ClassLoader classLoader;
    private final Map webServices = new HashMap();
    private final String objectName;
    private final WebManager manager;
    private static boolean first = true;
    public static final GBeanInfo GBEAN_INFO;

    public TomcatContainer() {
        this.objectName = null;
        this.setCatalinaHome(DEFAULT_CATALINA_HOME);
        this.manager = null;
    }

    public TomcatContainer(ClassLoader classLoader, String catalinaHome, ObjectRetriever engineGBean, ServerInfo serverInfo, String objectName, WebManager manager) {
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
            }
            catch (Exception e) {
                log.error((Object)"Error registering jndi stream handler", (Throwable)e);
            }
            catch (Throwable t) {
                log.info((Object)("Dual registration of jndi stream handler: " + t.getMessage()));
            }
        }
        if (catalinaHome == null) {
            catalinaHome = DEFAULT_CATALINA_HOME;
        }
        this.setCatalinaHome(serverInfo.resolveServerPath(catalinaHome));
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null.");
        }
        if (engineGBean == null) {
            throw new IllegalArgumentException("engineGBean cannot be null.");
        }
        this.classLoader = classLoader;
        this.engine = (Engine)engineGBean.getInternalObject();
        this.objectName = objectName;
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        log.debug((Object)"doStart()");
        log.debug((Object)("Endorsed Dirs set to:" + System.getProperty("java.endorsed.dirs")));
        if (this.embedded == null) {
            this.embedded = new TomcatGeronimoEmbedded();
        }
        this.embedded.setUseNaming(false);
        File rootContext = new File(System.getProperty("catalina.home") + "/ROOT");
        String docBase = "";
        if (rootContext.exists()) {
            docBase = "ROOT";
        }
        Container[] hosts = this.engine.findChildren();
        for (int i = 0; i < hosts.length; ++i) {
            Context defaultContext = this.embedded.createContext("", docBase, this.classLoader);
            if (defaultContext instanceof GeronimoStandardContext) {
                GeronimoStandardContext ctx = (GeronimoStandardContext)defaultContext;
                ctx.setJ2EEApplication(null);
                ctx.setJ2EEServer("geronimo");
            }
            hosts[i].addChild((Container)defaultContext);
        }
        this.embedded.addEngine(this.engine);
        this.embedded.start();
    }

    public void doStop() throws Exception {
        if (this.embedded != null) {
            this.embedded.stop();
            this.embedded = null;
        }
    }

    public void addContext(TomcatContext ctx) throws Exception {
        Container host;
        String virtualServer;
        Context anotherCtxObj = this.embedded.createContext(ctx.getContextPath(), ctx.getDocBase(), ctx.getClassLoader());
        ctx.setContext(anotherCtxObj);
        if (anotherCtxObj instanceof GeronimoStandardContext) {
            ((GeronimoStandardContext)anotherCtxObj).setContextProperties(ctx);
        }
        if ((virtualServer = ctx.getVirtualServer()) == null) {
            virtualServer = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualServer)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualServer + "'.  Do you have a matching Host entry in the plan?");
        }
        String securityRealmName = null;
        SecurityHolder secHolder = ctx.getSecurityHolder();
        if (secHolder != null) {
            securityRealmName = secHolder.getSecurityRealm();
        }
        if (ctx.getRealm() != null) {
            Realm realm = ctx.getRealm();
            if (securityRealmName != null && realm instanceof JAASRealm) {
                ((JAASRealm)realm).setAppName(securityRealmName);
            }
            anotherCtxObj.setRealm(realm);
        } else {
            Object realm = host.getRealm();
            if (securityRealmName != null) {
                String parentRealmName = null;
                if (realm instanceof JAASRealm) {
                    parentRealmName = ((JAASRealm)realm).getAppName();
                }
                if (!securityRealmName.equals(parentRealmName)) {
                    realm = secHolder.isSecurity() ? new TomcatGeronimoRealm() : new TomcatJAASRealm();
                    log.debug((Object)("The security-realm-name '" + securityRealmName + "' was specified and a parent (Engine/Host) is not named the same or no RealmGBean was configured for this context. " + "Creating a default " + realm.getClass().getName() + " adapter for this context."));
                    ((JAASRealm)realm).setUserClassNames("org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal");
                    ((JAASRealm)realm).setRoleClassNames("org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal");
                    ((JAASRealm)realm).setAppName(securityRealmName);
                    anotherCtxObj.setRealm((Realm)realm);
                } else {
                    anotherCtxObj.setRealm((Realm)realm);
                }
            } else {
                anotherCtxObj.setRealm((Realm)realm);
            }
        }
        host.addChild((Container)anotherCtxObj);
    }

    public void removeContext(TomcatContext ctx) {
        Context context = ctx.getContext();
        if (context != null) {
            if (context instanceof GeronimoStandardContext) {
                GeronimoStandardContext stdctx = (GeronimoStandardContext)context;
                try {
                    stdctx.stop();
                    stdctx.destroy();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            context.getParent().removeChild((Container)context);
        }
    }

    public void setCatalinaHome(String catalinaHome) {
        System.setProperty("catalina.home", catalinaHome);
    }

    public void addConnector(Connector connector) {
        this.embedded.addConnector(connector);
    }

    public void removeConnector(Connector connector) {
        this.embedded.removeConnector(connector);
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        Context webServiceContext = this.embedded.createEJBWebServiceContext(contextPath, webServiceContainer, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        String virtualServer = virtualHosts != null && virtualHosts.length > 0 ? virtualHosts[0] : this.engine.getDefaultHost();
        Container host = this.engine.findChild(virtualServer);
        if (host == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualServer + "'.  Do you have a matchiing Host entry in the plan?");
        }
        host.addChild((Container)webServiceContext);
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        TomcatEJBWebServiceContext context = (TomcatEJBWebServiceContext)((Object)this.webServices.get(contextPath));
        try {
            context.stop();
            context.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        context.getParent().removeChild((Container)context);
        this.webServices.remove(contextPath);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Web Container", (Class)TomcatContainer.class);
        infoFactory.setConstructor(new String[]{"classLoader", "catalinaHome", "EngineGBean", "ServerInfo", "objectName", "WebManager"});
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("catalinaHome", String.class, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addReference("EngineGBean", ObjectRetriever.class, "GBean");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("WebManager", WebManager.class);
        infoFactory.addOperation("addContext", new Class[]{TomcatContext.class});
        infoFactory.addOperation("removeContext", new Class[]{TomcatContext.class});
        infoFactory.addOperation("addConnector", new Class[]{Connector.class});
        infoFactory.addOperation("removeConnector", new Class[]{Connector.class});
        infoFactory.addInterface(SoapHandler.class);
        infoFactory.addInterface(TomcatWebContainer.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

