/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatWebConnector;

public class ConnectorGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever,
TomcatWebConnector {
    private static final Log log = LogFactory.getLog((Class)ConnectorGBean.class);
    public static final String CONNECTOR_CONTAINER_REFERENCE = "TomcatContainer";
    protected final Connector connector;
    private final TomcatContainer container;
    private String name;
    private String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public ConnectorGBean(String name, String protocol, String host, int port, TomcatContainer container) throws Exception {
        HashMap<String, String> initParams = new HashMap<String, String>();
        this.validateProtocol(protocol);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        initParams.put("address", host);
        initParams.put("port", Integer.toString(port));
        this.initializeParams(protocol, initParams);
        protocol = protocol != null && protocol.equals("AJP") ? "AJP/1.3" : null;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null.");
        }
        this.name = name;
        this.container = container;
        this.connector = new Connector(protocol);
        this.setParameters(this.connector, initParams);
    }

    protected void initializeParams(String protocol, Map params) {
    }

    protected void validateProtocol(String protocol) {
        if (protocol == null) {
            return;
        }
        if (protocol.equals("HTTPS")) {
            throw new IllegalArgumentException("Use a HttpsConnectorGBean for an HTTPS connector");
        }
        if (!protocol.equals("HTTP") && !protocol.equals("AJP")) {
            throw new IllegalArgumentException("Unrecognized protocol '" + protocol + "' (use the values of the PROTOCOL_* constants in WebConnector)");
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getInternalObject() {
        return this.connector;
    }

    public void doStart() throws LifecycleException {
        this.container.addConnector(this.connector);
        this.connector.start();
        log.debug((Object)(this.name + " connector started"));
    }

    public void doStop() {
        try {
            this.connector.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)e);
        }
        this.container.removeConnector(this.connector);
        log.debug((Object)(this.name + " connector stopped"));
    }

    public void doFail() {
        log.warn((Object)(this.name + " connector failed"));
        this.doStop();
    }

    public int getDefaultPort() {
        return this.getProtocol().equals("AJP") ? -1 : (this.getProtocol().equals("HTTP") ? 80 : (this.getProtocol().equals("HTTPS") ? 443 : -1));
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getHost();
            if (host == null || host.equals("0.0.0.0")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getCanonicalHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            this.connectHost = host;
        }
        return this.getProtocol().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public boolean isEmptySessionPath() {
        return this.connector.getEmptySessionPath();
    }

    public void setEmptySessionPath(boolean emptySessionPath) {
        this.connector.setEmptySessionPath(emptySessionPath);
    }

    public String getProtocol() {
        String protocol = this.connector.getProtocol();
        if (protocol.indexOf("AJP") > -1) {
            return "AJP";
        }
        if (this.connector.getScheme().equalsIgnoreCase("http")) {
            return "HTTP";
        }
        if (this.connector.getScheme().equalsIgnoreCase("https")) {
            return "HTTPS";
        }
        throw new IllegalStateException("Unknown protocol '" + protocol + "' and scheme '" + this.connector.getScheme() + "'");
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public String getHost() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    public void setHost(String host) throws UnknownHostException {
        this.connector.setAttribute("address", (Object)host);
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public int getBufferSizeBytes() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    public void setBufferSizeBytes(int bytes) {
        this.connector.setAttribute("bufferSize", (Object)new Integer(bytes));
    }

    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    public void setMaxThreads(int threads) {
        this.connector.setAttribute("maxThreads", (Object)new Integer(threads));
    }

    public int getAcceptQueueSize() {
        Object value = this.connector.getAttribute("acceptCount");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public void setAcceptQueueSize(int size) {
        this.connector.setAttribute("acceptCount", (Object)new Integer(size));
    }

    public int getLingerMillis() {
        Object value = this.connector.getAttribute("connectionLinger");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public void setLingerMillis(int millis) {
        this.connector.setAttribute("connectionLinger", (Object)new Integer(millis));
    }

    public boolean isTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : new Boolean(value.toString());
    }

    public void setTcpNoDelay(boolean enable) {
        this.connector.setAttribute("tcpNoDelay", (Object)new Boolean(enable));
    }

    public int getRedirectPort() {
        return this.connector.getRedirectPort();
    }

    public void setRedirectPort(int port) {
        this.connector.setRedirectPort(port);
    }

    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 4 : Integer.parseInt(value.toString());
    }

    public void setMinSpareThreads(int threads) {
        this.connector.setAttribute("minSpareThreads", (Object)new Integer(threads));
    }

    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 50 : Integer.parseInt(value.toString());
    }

    public void setMaxSpareThreads(int threads) {
        this.connector.setAttribute("maxSpareThreads", (Object)new Integer(threads));
    }

    public int getMaxHttpHeaderSizeBytes() {
        Object value = this.connector.getAttribute("maxHttpHeaderSize");
        return value == null ? 4096 : Integer.parseInt(value.toString());
    }

    public void setMaxHttpHeaderSizeBytes(int bytes) {
        this.connector.setAttribute("maxHttpHeaderSize", (Object)new Integer(bytes));
    }

    public boolean isHostLookupEnabled() {
        return this.connector.getEnableLookups();
    }

    public void setHostLookupEnabled(boolean enabled) {
        this.connector.setEnableLookups(enabled);
    }

    public int getConnectionTimeoutMillis() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? 60000 : Integer.parseInt(value.toString());
    }

    public void setConnectionTimeoutMillis(int millis) {
        this.connector.setAttribute("connectionTimeout", (Object)new Integer(millis));
    }

    public boolean isUploadTimeoutEnabled() {
        Object value = this.connector.getAttribute("disableUploadTimeout");
        return value == null ? true : new Boolean(value.toString()) == false;
    }

    public void setUploadTimeoutEnabled(boolean enabled) {
        this.connector.setAttribute("disableUploadTimeout", (Object)new Boolean(!enabled));
    }

    public int getMaxPostSize() {
        int value = this.connector.getMaxPostSize();
        return value == 0 ? 0x200000 : value;
    }

    public void setMaxPostSize(int bytes) {
        this.connector.setMaxPostSize(bytes);
    }

    public int getMaxSavePostSize() {
        int value = this.connector.getMaxSavePostSize();
        return value == 0 ? 4096 : value;
    }

    public void setMaxSavePostSize(int kbytes) {
        this.connector.setMaxSavePostSize(kbytes);
    }

    public int getMaxKeepAliveRequests() {
        Object value = this.connector.getAttribute("maxKeepAliveRequests");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.connector.setAttribute("maxKeepAliveRequests", (Object)new Integer(maxKeepAliveRequests));
    }

    public int getSocketBuffer() {
        Object value = this.connector.getAttribute("socketBuffer");
        return value == null ? 9000 : Integer.parseInt(value.toString());
    }

    public void setSocketBuffer(int kbytes) {
        this.connector.setAttribute("socketBuffer", (Object)new Integer(kbytes));
    }

    public boolean getUseBodyEncodingForURI() {
        return this.connector.getUseBodyEncodingForURI();
    }

    public void setUseBodyEncodingForURI(boolean enabled) {
        this.connector.setUseBodyEncodingForURI(enabled);
    }

    public void setAllowTrace(boolean allow) {
        this.connector.setAllowTrace(allow);
    }

    public boolean getAllowTrace() {
        return this.connector.getAllowTrace();
    }

    public void setProxyName(String proxyName) {
        this.connector.setProxyName(proxyName);
    }

    public String getProxyName() {
        return this.connector.getProxyName();
    }

    public void setProxyPort(int port) {
        this.connector.setProxyPort(port);
    }

    public int getProxyPort() {
        return this.connector.getProxyPort();
    }

    public void setScheme(String scheme) {
        this.connector.setScheme(scheme);
    }

    public String getScheme() {
        return this.connector.getScheme();
    }

    public void setUriEncoding(String encoding) {
        this.connector.setURIEncoding(encoding);
    }

    public String getUriEncoding() {
        return this.connector.getURIEncoding();
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.connector.setUseIPVHosts(useIPVHosts);
    }

    public boolean getUseIPVHosts() {
        return this.connector.getUseIPVHosts();
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.connector.setXpoweredBy(xpoweredBy);
    }

    public boolean getXpoweredBy() {
        return this.connector.getXpoweredBy();
    }

    public void setCompressableMimeType(String compressableMimeType) {
        this.connector.setAttribute("compressableMimeType", (Object)compressableMimeType);
    }

    public String getCompressableMimeType() {
        return (String)this.connector.getAttribute("compressableMimeType");
    }

    public void setCompression(String compression) {
        this.connector.setAttribute("compression", (Object)compression);
    }

    public String getCompression() {
        return (String)this.connector.getAttribute("compression");
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.connector.setAttribute("noCompressionUserAgents", (Object)noCompressionUserAgents);
    }

    public String getNoCompressionUserAgents() {
        return (String)this.connector.getAttribute("noCompressionUserAgents");
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.connector.setAttribute("restrictedUserAgents", (Object)restrictedUserAgents);
    }

    public String getRestrictedUserAgents() {
        return (String)this.connector.getAttribute("restrictedUserAgents");
    }

    public void setThreadPriority(int threadPriority) {
        this.connector.setAttribute("threadPriority", (Object)new Integer(threadPriority));
    }

    public int getThreadPriority() {
        Object value = this.connector.getAttribute("threadPriority");
        return value == null ? 5 : Integer.parseInt(value.toString());
    }

    public void setServer(String server) {
        this.connector.setAttribute("server", (Object)server);
    }

    public String getServer() {
        return (String)this.connector.getAttribute("server");
    }

    public void setStrategy(String strategy) {
        this.connector.setAttribute("strategy", (Object)strategy);
    }

    public String getStrategy() {
        return (String)this.connector.getAttribute("strategy");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", (Class)ConnectorGBean.class);
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, TomcatContainer.class, "GBean");
        infoFactory.addOperation("getInternalObject");
        infoFactory.addInterface(TomcatWebConnector.class, new String[]{"host", "port", "bufferSizeBytes", "maxThreads", "acceptQueueSize", "lingerMillis", "tcpNoDelay", "redirectPort", "minSpareThreads", "maxSpareThreads", "maxHttpHeaderSizeBytes", "hostLookupEnabled", "connectionTimeoutMillis", "uploadTimeoutEnabled", "connectUrl", "maxPostSize", "maxSavePostSize", "emptySessionPath", "maxKeepAliveRequests", "socketBuffer", "useBodyEncodingForURI", "allowTrace", "proxyName", "proxyPort", "scheme", "secure", "uriEncoding", "useIPVHosts", "xpoweredBy", "compressableMimeType", "compression", "noCompressionUserAgents", "restrictedUserAgents", "threadPriority", "server", "strategy"}, new String[]{"host", "port", "redirectPort", "maxThreads"});
        infoFactory.setConstructor(new String[]{"name", "protocol", "host", "port", CONNECTOR_CONTAINER_REFERENCE});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

