/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathListener;
import org.apache.xmlbeans.XmlCursor;

public class DDBeanImpl
implements DDBean {
    protected final DDBeanRoot root;
    protected final String xpath;
    protected final Map children;
    protected final String content;
    protected final Map attributeMap;
    protected final DDBean parent;

    public DDBeanImpl(DDBeanRoot root, DDBean parent, String xpath, XmlCursor c) {
        this.root = root;
        this.parent = parent;
        this.xpath = xpath;
        this.children = new HashMap();
        this.attributeMap = new HashMap();
        this.content = c.getTextValue();
        c.push();
        if (c.toFirstAttribute()) {
            do {
                this.attributeMap.put(c.getName().getLocalPart(), c.getTextValue());
            } while (c.toNextAttribute());
        }
        c.pop();
        c.push();
        if (c.toFirstChild()) {
            do {
                String name;
                ArrayList<DDBeanImpl> nodes;
                if ((nodes = (ArrayList<DDBeanImpl>)this.children.get(name = c.getName().getLocalPart())) == null) {
                    nodes = new ArrayList<DDBeanImpl>();
                    this.children.put(name, nodes);
                }
                nodes.add(new DDBeanImpl(root, this, xpath + "/" + name, c));
            } while (c.toNextSibling());
        }
        c.pop();
    }

    DDBeanImpl(DDBeanImpl source, String xpath) {
        this.xpath = xpath;
        this.root = source.root;
        this.parent = source.parent;
        this.children = source.children;
        this.content = source.content;
        this.attributeMap = source.attributeMap;
    }

    public DDBeanRoot getRoot() {
        return this.root;
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getText() {
        return this.content;
    }

    public String getId() {
        return this.getAttributeValue("id");
    }

    public String getAttributeValue(String attrName) {
        String value = (String)this.attributeMap.get(attrName);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public String[] getText(String xpath) {
        DDBean[] beans = this.getChildBean(xpath);
        if (beans == null) {
            return null;
        }
        String[] text = new String[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            text[i] = beans[i].getText();
        }
        return text;
    }

    public DDBean[] getChildBean(String xpath) {
        if (xpath.startsWith("/")) {
            return this.getRoot().getChildBean(xpath.substring(1));
        }
        if (xpath.equals(".")) {
            return new DDBean[]{this};
        }
        if (xpath.startsWith("./")) {
            return this.getChildBean(xpath.substring(2));
        }
        if (xpath.startsWith("..")) {
            if (xpath.length() == 2) {
                return new DDBean[]{this.parent};
            }
            return this.parent.getChildBean(xpath.substring(3));
        }
        int index = xpath.indexOf(47);
        if (index == -1) {
            List beans = (List)this.children.get(xpath);
            if (beans == null) {
                return null;
            }
            DDBean[] newDDBeans = beans.toArray(new DDBean[beans.size()]);
            for (int i = 0; i < newDDBeans.length; ++i) {
                newDDBeans[i] = new DDBeanImpl((DDBeanImpl)newDDBeans[i], xpath);
            }
            return newDDBeans;
        }
        List childBeans = (List)this.children.get(xpath.substring(0, index));
        if (childBeans == null) {
            return null;
        }
        String path = xpath.substring(index + 1);
        ArrayList<DDBeanImpl> beans = new ArrayList<DDBeanImpl>();
        Iterator i = childBeans.iterator();
        while (i.hasNext()) {
            DDBean bean = (DDBean)i.next();
            DDBean[] childs = bean.getChildBean(path);
            if (childs == null) continue;
            for (int j = 0; j < childs.length; ++j) {
                beans.add(new DDBeanImpl((DDBeanImpl)childs[j], xpath));
            }
        }
        return beans.size() > 0 ? beans.toArray(new DDBean[beans.size()]) : null;
    }

    public String[] getAttributeNames() {
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.size()]);
    }

    public void addXpathListener(String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(String xpath, XpathListener xpl) {
    }

    public boolean equals(Object other) {
        if (other.getClass() != DDBeanImpl.class) {
            return false;
        }
        DDBeanImpl otherdd = (DDBeanImpl)other;
        return this.xpath.equals(otherdd.xpath) && ((Object)this.children).equals(otherdd.children) && ((Object)this.attributeMap).equals(otherdd.attributeMap) && this.root.equals(otherdd.root);
    }

    public int hashCode() {
        return this.xpath.hashCode() ^ ((Object)this.attributeMap).hashCode() ^ this.root.hashCode();
    }
}

