/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.PluginMetadata;

public class PluginList
implements Serializable {
    private final URL[] repositories;
    private final PluginMetadata[] plugins;

    public PluginList(URL[] repositories, PluginMetadata[] plugins) {
        this.repositories = repositories;
        this.plugins = plugins;
    }

    public static PluginList createInstallList(PluginList all, Artifact[] selectedConfigIDs) {
        int i;
        URL[] repositories = all.repositories;
        ArrayList<PluginMetadata> list = new ArrayList<PluginMetadata>();
        HashSet<Artifact> set = new HashSet<Artifact>();
        for (i = 0; i < selectedConfigIDs.length; ++i) {
            Artifact artifact = selectedConfigIDs[i];
            set.add(artifact);
        }
        for (i = 0; i < all.getPlugins().length; ++i) {
            PluginMetadata metadata = all.getPlugins()[i];
            if (!set.contains(metadata.getModuleId())) continue;
            if (metadata.isInstalled() || !metadata.isEligible()) {
                throw new IllegalArgumentException("Cannot install " + metadata.getModuleId());
            }
            list.add(metadata);
        }
        if (list.size() == 0) {
            return null;
        }
        PluginMetadata[] configurations = list.toArray(new PluginMetadata[list.size()]);
        return new PluginList(repositories, configurations);
    }

    public static PluginList createInstallList(PluginList all, Artifact selectedConfigID) {
        URL[] repositories = all.repositories;
        PluginMetadata target = null;
        for (int i = 0; i < all.getPlugins().length; ++i) {
            PluginMetadata metadata = all.getPlugins()[i];
            if (!selectedConfigID.equals((Object)metadata.getModuleId())) continue;
            if (metadata.isInstalled() || !metadata.isEligible()) {
                throw new IllegalArgumentException("Cannot install " + metadata.getModuleId());
            }
            target = metadata;
            break;
        }
        if (target == null) {
            return null;
        }
        return new PluginList(repositories, new PluginMetadata[]{target});
    }

    public URL[] getRepositories() {
        return this.repositories;
    }

    public PluginMetadata[] getPlugins() {
        return this.plugins;
    }
}

