/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service.jsr88;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.geronimo.deployment.plugin.XmlBeanSupport;
import org.apache.geronimo.deployment.service.jsr88.Artifact;
import org.apache.geronimo.deployment.xbeans.DependenciesType;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;

public class EnvironmentData
extends XmlBeanSupport {
    static final SchemaTypeLoader SCHEMA_TYPE_LOADER = XmlBeans.typeLoaderForClassLoader((ClassLoader)EnvironmentType.class.getClassLoader());
    private Artifact configId;
    private Artifact[] dependencies = new Artifact[0];

    public EnvironmentData() {
        super(null);
    }

    public EnvironmentData(EnvironmentType dependency) {
        super(null);
        this.configure(dependency);
    }

    protected EnvironmentType getEnvironmentType() {
        return (EnvironmentType)this.getXmlObject();
    }

    public void configure(EnvironmentType env) {
        this.setXmlObject(env);
        if (env.isSetModuleId()) {
            this.configId = new Artifact(env.getModuleId());
        }
        if (env.isSetDependencies()) {
            DependenciesType deps = env.getDependencies();
            this.dependencies = new Artifact[deps.getDependencyArray().length];
            for (int i = 0; i < this.dependencies.length; ++i) {
                this.dependencies[i] = new Artifact(deps.getDependencyArray(i));
            }
        }
    }

    public Artifact getConfigId() {
        return this.configId;
    }

    public void setConfigId(Artifact configId) {
        Artifact old = this.configId;
        this.configId = configId;
        if (old == null && configId == null || old != null && old == configId) {
            return;
        }
        if (old != null) {
            this.getEnvironmentType().unsetModuleId();
        }
        if (configId != null) {
            configId.configure(this.getEnvironmentType().addNewModuleId());
        }
        this.pcs.firePropertyChange("moduleId", (Object)old, (Object)configId);
    }

    public Artifact[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Artifact[] dependencies) {
        int i;
        Artifact[] old = this.dependencies;
        HashSet<Artifact> before = new HashSet<Artifact>();
        for (i = 0; i < old.length; ++i) {
            before.add(old[i]);
        }
        this.dependencies = dependencies;
        for (i = 0; i < dependencies.length; ++i) {
            Artifact dep = dependencies[i];
            if (dep.getArtifactType() == null) {
                if (!this.getEnvironmentType().isSetDependencies()) {
                    this.getEnvironmentType().addNewDependencies();
                }
                dep.configure(this.getEnvironmentType().getDependencies().addNewDependency());
                continue;
            }
            before.remove((Object)dep);
        }
        Iterator it = before.iterator();
        block2: while (it.hasNext()) {
            Artifact adapter = (Artifact)((Object)it.next());
            DependencyType[] all = this.getEnvironmentType().getDependencies().getDependencyArray();
            for (int i2 = 0; i2 < all.length; ++i2) {
                if (all[i2] != adapter) continue;
                this.getEnvironmentType().getDependencies().removeDependency(i2);
                continue block2;
            }
        }
        if (this.getEnvironmentType().isSetDependencies() && this.getEnvironmentType().getDependencies().getDependencyArray().length == 0) {
            this.getEnvironmentType().unsetDependencies();
        }
        this.pcs.firePropertyChange("dependencies", old, dependencies);
    }

    public String[] getHiddenClasses() {
        return this.getEnvironmentType().getHiddenClasses().getFilterArray();
    }

    public void setHiddenClasses(String[] hidden) {
        String[] old;
        String[] stringArray = old = this.getEnvironmentType().isSetHiddenClasses() ? this.getEnvironmentType().getHiddenClasses().getFilterArray() : null;
        if (!this.getEnvironmentType().isSetHiddenClasses()) {
            this.getEnvironmentType().addNewHiddenClasses();
        }
        this.getEnvironmentType().getHiddenClasses().setFilterArray(hidden);
        this.pcs.firePropertyChange("hiddenClasses", old, hidden);
    }

    public String[] getNonOverridableClasses() {
        return this.getEnvironmentType().getNonOverridableClasses().getFilterArray();
    }

    public void setNonOverridableClasses(String[] fixed) {
        String[] old;
        String[] stringArray = old = this.getEnvironmentType().isSetNonOverridableClasses() ? this.getEnvironmentType().getNonOverridableClasses().getFilterArray() : null;
        if (!this.getEnvironmentType().isSetNonOverridableClasses()) {
            this.getEnvironmentType().addNewNonOverridableClasses();
        }
        this.getEnvironmentType().getNonOverridableClasses().setFilterArray(fixed);
        this.pcs.firePropertyChange("nonOverridableClasses", old, fixed);
    }

    public boolean isInverseClassLoading() {
        return this.getEnvironmentType().isSetInverseClassloading();
    }

    public void setInverseClassLoading(boolean inverse) {
        boolean old = this.isInverseClassLoading();
        if (!inverse) {
            if (old) {
                this.getEnvironmentType().unsetInverseClassloading();
            }
        } else if (!old) {
            this.getEnvironmentType().addNewInverseClassloading();
        }
        this.pcs.firePropertyChange("inverseClassLoading", old, inverse);
    }

    public boolean isSuppressDefaultEnvironment() {
        return this.getEnvironmentType().isSetSuppressDefaultEnvironment();
    }

    public void setSuppressDefaultEnvironment(boolean suppress) {
        boolean old = this.isSuppressDefaultEnvironment();
        if (!suppress) {
            if (old) {
                this.getEnvironmentType().unsetSuppressDefaultEnvironment();
            }
        } else if (!old) {
            this.getEnvironmentType().addNewSuppressDefaultEnvironment();
        }
        this.pcs.firePropertyChange("suppressDefaultEnvironment", old, suppress);
    }

    protected SchemaTypeLoader getSchemaTypeLoader() {
        return SCHEMA_TYPE_LOADER;
    }
}

