/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.credentialstore.CredentialStore;
import org.apache.geronimo.security.deploy.SubjectInfo;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jacc.PrincipalRoleMapper;
import org.apache.geronimo.security.jacc.RunAsSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPolicyConfigurationManager
implements GBeanLifecycle,
RunAsSource {
    private final Map<String, PolicyConfiguration> contextIdToPolicyConfigurationMap = new HashMap<String, PolicyConfiguration>();
    private final Map<String, Subject> roleDesignates = new HashMap<String, Subject>();
    private final Subject defaultSubject;
    private final PrincipalRoleMapper principalRoleMapper;
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPolicyConfigurationManager(Map<String, ComponentPermissions> contextIdToPermissionsMap, SubjectInfo defaultSubjectInfo, Map<String, SubjectInfo> roleDesignates, ClassLoader cl, CredentialStore credentialStore, PrincipalRoleMapper principalRoleMapper) throws PolicyContextException, ClassNotFoundException, LoginException {
        PolicyConfigurationFactory policyConfigurationFactory;
        if (!(credentialStore != null || roleDesignates.isEmpty() && defaultSubjectInfo == null)) {
            throw new NullPointerException("No CredentialStore supplied to resolve default and run-as subjects");
        }
        this.principalRoleMapper = principalRoleMapper;
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(cl);
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
        for (Map.Entry<String, ComponentPermissions> entry : contextIdToPermissionsMap.entrySet()) {
            String contextID = entry.getKey();
            ComponentPermissions componentPermissions = entry.getValue();
            PolicyConfiguration policyConfiguration = policyConfigurationFactory.getPolicyConfiguration(contextID, true);
            this.contextIdToPolicyConfigurationMap.put(contextID, policyConfiguration);
            policyConfiguration.addToExcludedPolicy(componentPermissions.getExcludedPermissions());
            policyConfiguration.addToUncheckedPolicy(componentPermissions.getUncheckedPermissions());
            for (Map.Entry<String, PermissionCollection> roleEntry : componentPermissions.getRolePermissions().entrySet()) {
                String roleName = roleEntry.getKey();
                PermissionCollection rolePermissions = roleEntry.getValue();
                Enumeration<Permission> permissions = rolePermissions.elements();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    policyConfiguration.addToRole(roleName, permission);
                }
            }
        }
        if (principalRoleMapper != null) {
            principalRoleMapper.install(contextIdToPermissionsMap.keySet());
        }
        for (PolicyConfiguration policyConfiguration : this.contextIdToPolicyConfigurationMap.values()) {
            for (PolicyConfiguration policyConfiguration2 : this.contextIdToPolicyConfigurationMap.values()) {
                if (policyConfiguration == policyConfiguration2) continue;
                policyConfiguration.linkConfiguration(policyConfiguration2);
            }
        }
        for (PolicyConfiguration policyConfiguration : this.contextIdToPolicyConfigurationMap.values()) {
            policyConfiguration.commit();
        }
        Policy policy = Policy.getPolicy();
        policy.refresh();
        if (defaultSubjectInfo == null) {
            this.defaultSubject = ContextManager.EMPTY;
        } else {
            this.defaultSubject = credentialStore.getSubject(defaultSubjectInfo.getRealm(), defaultSubjectInfo.getId());
            this.registerSubject(this.defaultSubject);
        }
        for (Map.Entry<String, SubjectInfo> entry : roleDesignates.entrySet()) {
            String role = entry.getKey();
            SubjectInfo subjectInfo = entry.getValue();
            if (subjectInfo == null || credentialStore == null) {
                throw new NullPointerException("No subjectInfo for role " + role);
            }
            Subject roleDesignate = credentialStore.getSubject(subjectInfo.getRealm(), subjectInfo.getId());
            this.registerSubject(roleDesignate);
            this.roleDesignates.put(role, roleDesignate);
        }
    }

    private void registerSubject(Subject subject) {
        ContextManager.registerSubject(subject);
        SubjectId id = ContextManager.getSubjectId(subject);
        subject.getPrincipals().add(new IdentificationPrincipal(id));
    }

    @Override
    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    @Override
    public Subject getSubjectForRole(String role) {
        return this.roleDesignates.get(role);
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        for (Map.Entry<String, Subject> entry : this.roleDesignates.entrySet()) {
            Subject roleDesignate = entry.getValue();
            ContextManager.unregisterSubject(roleDesignate);
        }
        if (this.defaultSubject != ContextManager.EMPTY) {
            ContextManager.unregisterSubject(this.defaultSubject);
        }
        if (this.principalRoleMapper != null) {
            this.principalRoleMapper.uninstall();
        }
        for (PolicyConfiguration policyConfiguration : this.contextIdToPolicyConfigurationMap.values()) {
            policyConfiguration.delete();
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ApplicationPolicyConfigurationManager.class, (String)"JACCManager");
        infoBuilder.addAttribute("contextIdToPermissionsMap", Map.class, true);
        infoBuilder.addAttribute("defaultSubjectInfo", SubjectInfo.class, true);
        infoBuilder.addAttribute("roleDesignates", Map.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addReference("CredentialStore", CredentialStore.class, "GBean");
        infoBuilder.addReference("PrincipalRoleMapper", PrincipalRoleMapper.class, "JACCManager");
        infoBuilder.setConstructor(new String[]{"contextIdToPermissionsMap", "defaultSubjectInfo", "roleDesignates", "classLoader", "CredentialStore", "PrincipalRoleMapper"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

