/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.apache.geronimo.security.jaas.UsernamePasswordCredential;

public class ConfiguredIdentityNamedUsernamePasswordLoginModule
implements LoginModule {
    public static final String CREDENTIAL_NAME = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Name";
    public static final String USER_NAME = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Username";
    public static final String PASSWORD = "org.apache.geronimo.jaas.NamedUsernamePasswordCredential.Password";
    private Subject subject;
    private NamedUsernamePasswordCredential namedUsernamePasswordCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        String name = (String)options.get(CREDENTIAL_NAME);
        String username = (String)options.get(USER_NAME);
        String password = (String)options.get(PASSWORD);
        this.namedUsernamePasswordCredential = new NamedUsernamePasswordCredential(username, password.toCharArray(), name);
    }

    public boolean login() throws LoginException {
        return false;
    }

    public boolean commit() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Object> pvtCreds = this.subject.getPrivateCredentials();
        if (this.namedUsernamePasswordCredential != null && !pvtCreds.contains(this.namedUsernamePasswordCredential)) {
            pvtCreds.add(this.namedUsernamePasswordCredential);
        }
        return false;
    }

    public boolean abort() throws LoginException {
        return this.logout();
    }

    public boolean logout() throws LoginException {
        if (this.namedUsernamePasswordCredential == null) {
            return false;
        }
        Set<UsernamePasswordCredential> pvtCreds = this.subject.getPrivateCredentials(UsernamePasswordCredential.class);
        if (pvtCreds.contains(this.namedUsernamePasswordCredential)) {
            pvtCreds.remove(this.namedUsernamePasswordCredential);
        }
        try {
            this.namedUsernamePasswordCredential.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        this.namedUsernamePasswordCredential = null;
        return false;
    }
}

