/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.realm.providers.CertificateCallback;
import org.apache.geronimo.security.realm.providers.CertificateChainCallback;

public class CertificateChainCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(CertificateChainCallbackHandler.class);
    Certificate[] certificateChain;

    public CertificateChainCallbackHandler(Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cc;
            Callback callback = callbacks[i];
            if (callback instanceof CertificateChainCallback) {
                cc = (CertificateChainCallback)callback;
                ((CertificateChainCallback)cc).setCertificateChain(this.certificateChain);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                if (this.certificateChain != null && this.certificateChain.length > 0 && this.certificateChain[0] instanceof X509Certificate) {
                    cc = (CertificateCallback)callback;
                    ((CertificateCallback)cc).setCertificate((X509Certificate)this.certificateChain[0]);
                    continue;
                }
                StringBuffer buf = new StringBuffer("Invalid certificate chain: \n");
                if (this.certificateChain == null) {
                    buf.append("certificate chain is null");
                } else {
                    buf.append("certificate chain length: ").append(this.certificateChain.length).append("\n");
                    if (this.certificateChain.length > 0) {
                        buf.append("first certificate is a: ").append(this.certificateChain[0].getClass()).append("\n");
                        buf.append("certificate is an X509Certificate: ").append(this.certificateChain[0] instanceof X509Certificate).append("\n");
                    }
                }
                throw new UnsupportedCallbackException(callback, buf.toString());
            }
            throw new UnsupportedCallbackException(callback, "Wrong callback type: " + callback.getClass());
        }
    }
}

