/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas.client;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.client.ClientLoginModuleProxy;

public class WrappingClientLoginModuleProxy
extends ClientLoginModuleProxy {
    private final String loginDomainName;
    private final String realmName;
    private final Subject localSubject = new Subject();

    public WrappingClientLoginModuleProxy(LoginModuleControlFlag controlFlag, Subject subject, LoginModule source, String loginDomainName, String realmName) {
        super(controlFlag, subject, source);
        this.loginDomainName = loginDomainName;
        this.realmName = realmName;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(this.localSubject, callbackHandler, sharedState, options);
    }

    public boolean commit() throws LoginException {
        boolean result = super.commit();
        HashSet<Principal> wrapped = new HashSet<Principal>();
        Iterator<Principal> iter = this.subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal principal = iter.next();
            wrapped.add(new DomainPrincipal(this.loginDomainName, principal));
            wrapped.add(new RealmPrincipal(this.realmName, this.loginDomainName, principal));
        }
        this.localSubject.getPrincipals().addAll(wrapped);
        this.subject.getPrincipals().addAll(this.localSubject.getPrincipals());
        return result;
    }

    public boolean logout() throws LoginException {
        boolean result = super.logout();
        this.subject.getPrincipals().removeAll(this.localSubject.getPrincipals());
        this.localSubject.getPrincipals().clear();
        return result;
    }
}

