/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.geronimo.persistence.EntityManagerWrapper;
import org.apache.geronimo.persistence.NoTxQueryWrapper;
import org.apache.geronimo.persistence.NoTxTypedQueryWrapper;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

public class CMPEntityManagerTxScoped
implements EntityManager {
    private final TransactionManagerImpl transactionManager;
    private final String persistenceUnit;
    private final EntityManagerFactory entityManagerFactory;
    private final Map entityManagerProperties;

    public CMPEntityManagerTxScoped(TransactionManagerImpl transactionManager, String persistenceUnit, EntityManagerFactory entityManagerFactory, Map entityManagerProperties) {
        this.transactionManager = transactionManager;
        this.persistenceUnit = persistenceUnit;
        this.entityManagerFactory = entityManagerFactory;
        this.entityManagerProperties = entityManagerProperties;
    }

    private EntityManager getEntityManager(boolean activeRequired) {
        TransactionImpl transaction = (TransactionImpl)this.transactionManager.getTransaction();
        if (activeRequired && (transaction == null || transaction.getStatus() != 0)) {
            throw new TransactionRequiredException("No active transaction");
        }
        if (transaction == null) {
            return null;
        }
        EntityManagerWrapper entityManagerWrapper = (EntityManagerWrapper)this.transactionManager.getResource((Object)this.persistenceUnit);
        if (entityManagerWrapper == null) {
            EntityManager entityManager = this.createEntityManager();
            entityManagerWrapper = new EntityManagerWrapperTxScoped(entityManager);
            this.transactionManager.putResource((Object)this.persistenceUnit, (Object)entityManagerWrapper);
            try {
                transaction.registerSynchronization((Synchronization)entityManagerWrapper);
            }
            catch (RollbackException e) {
                throw (TransactionRequiredException)new TransactionRequiredException("No active transaction").initCause((Throwable)e);
            }
            catch (SystemException e) {
                throw (TransactionRequiredException)new TransactionRequiredException("No active transaction").initCause((Throwable)e);
            }
        }
        return entityManagerWrapper.getEntityManager();
    }

    private EntityManager createEntityManager() {
        EntityManager entityManager = this.entityManagerProperties == null ? this.entityManagerFactory.createEntityManager() : this.entityManagerFactory.createEntityManager(this.entityManagerProperties);
        return entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.persist(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.persist(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T t) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            return (T)entityManager.merge(t);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.merge(t);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.remove(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.remove(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> aClass, Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.find(aClass, o);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.find(aClass, o);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> aClass, Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.getReference(aClass, o);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.getReference(aClass, o);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.flush();
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.flush();
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushModeType) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.setFlushMode(flushModeType);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.setFlushMode(flushModeType);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getFlushMode();
        }
        entityManager = this.createEntityManager();
        try {
            FlushModeType flushModeType = entityManager.getFlushMode();
            return flushModeType;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object o, LockModeType lockModeType) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.lock(o, lockModeType);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.lock(o, lockModeType);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object o) {
        EntityManager entityManager = this.getEntityManager(true);
        if (entityManager != null) {
            entityManager.refresh(o);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.refresh(o);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.clear();
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.clear();
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.contains(o);
        }
        entityManager = this.createEntityManager();
        try {
            boolean bl = entityManager.contains(o);
            return bl;
        }
        finally {
            entityManager.close();
        }
    }

    public Query createQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createQuery(s);
        }
        entityManager = this.createEntityManager();
        return new NoTxQueryWrapper(entityManager, entityManager.createQuery(s));
    }

    public Query createNamedQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNamedQuery(s);
        }
        entityManager = this.createEntityManager();
        return new NoTxQueryWrapper(entityManager, entityManager.createNamedQuery(s));
    }

    public Query createNativeQuery(String s) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s);
        }
        entityManager = this.createEntityManager();
        return new NoTxQueryWrapper(entityManager, entityManager.createNativeQuery(s));
    }

    public Query createNativeQuery(String s, Class aClass) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s, aClass);
        }
        entityManager = this.createEntityManager();
        return new NoTxQueryWrapper(entityManager, entityManager.createNativeQuery(s, aClass));
    }

    public Query createNativeQuery(String s, String s1) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNativeQuery(s, s1);
        }
        entityManager = this.createEntityManager();
        return new NoTxQueryWrapper(entityManager, entityManager.createNativeQuery(s, s1));
    }

    public void close() {
        throw new IllegalStateException("You cannot call close on a Container Managed Entity Manager");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("You cannot call getTransaction on a container managed EntityManager");
    }

    public void joinTransaction() {
        throw new IllegalStateException("You cannot call joinTransaction on a container managed EntityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getDelegate();
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.getDelegate();
            return object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getMetamodel();
        }
        entityManager = this.createEntityManager();
        try {
            Metamodel metamodel = entityManager.getMetamodel();
            return metamodel;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getCriteriaBuilder();
        }
        entityManager = this.createEntityManager();
        try {
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            entityManager.close();
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createNamedQuery(name, resultClass);
        }
        entityManager = this.createEntityManager();
        return new NoTxTypedQueryWrapper(entityManager, entityManager.createNamedQuery(name, resultClass));
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createQuery(criteriaQuery);
        }
        entityManager = this.createEntityManager();
        return new NoTxTypedQueryWrapper(entityManager, entityManager.createQuery(criteriaQuery));
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.createQuery(qlString, resultClass);
        }
        entityManager = this.createEntityManager();
        return new NoTxTypedQueryWrapper(entityManager, entityManager.createQuery(qlString, resultClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object entity) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.detach(entity);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.detach(entity);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.find(entityClass, primaryKey, properties);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.find(entityClass, primaryKey, properties);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.find(entityClass, primaryKey, lockMode);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.find(entityClass, primaryKey, lockMode);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.find(entityClass, primaryKey, lockMode, properties);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.find(entityClass, primaryKey, lockMode, properties);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getLockMode(entity);
        }
        entityManager = this.createEntityManager();
        try {
            LockModeType lockModeType = entityManager.getLockMode(entity);
            return lockModeType;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return entityManager.getProperties();
        }
        entityManager = this.createEntityManager();
        try {
            Map map = entityManager.getProperties();
            return map;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.lock(entity, lockMode, properties);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.lock(entity, lockMode, properties);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.refresh(entity, properties);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.refresh(entity, properties);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.refresh(entity, lockMode);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.refresh(entity, lockMode);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.refresh(entity, lockMode, properties);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.refresh(entity, lockMode, properties);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            entityManager.setProperty(propertyName, value);
        } else {
            entityManager = this.createEntityManager();
            try {
                entityManager.setProperty(propertyName, value);
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> cls) {
        EntityManager entityManager = this.getEntityManager(false);
        if (entityManager != null) {
            return (T)entityManager.unwrap(cls);
        }
        entityManager = this.createEntityManager();
        try {
            Object object = entityManager.unwrap(cls);
            return (T)object;
        }
        finally {
            entityManager.close();
        }
    }

    private static class EntityManagerWrapperTxScoped
    implements EntityManagerWrapper,
    Synchronization {
        private final EntityManager entityManager;

        public EntityManagerWrapperTxScoped(EntityManager entityManager) {
            if (entityManager == null) {
                throw new IllegalArgumentException("Need a non-null entity manager");
            }
            this.entityManager = entityManager;
        }

        public void close() {
            this.entityManager.close();
        }

        @Override
        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.close();
        }
    }
}

