/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.apache.geronimo.bval.ValidatorFactoryGBean;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.classloader.TemporaryClassLoader;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.persistence.CMPEntityManagerExtended;
import org.apache.geronimo.persistence.CMPEntityManagerTxScoped;
import org.apache.geronimo.persistence.ExtendedEntityManagerRegistry;
import org.apache.geronimo.persistence.TransformerWrapper;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transformer.TransformerAgent;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xbean.osgi.bundle.util.BundleResourceHelper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="PersistenceUnit")
public class PersistenceUnitGBean
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(PersistenceUnitGBean.class);
    private static final List<URL> NO_URLS = Collections.emptyList();
    private static final List<String> NO_STRINGS = Collections.emptyList();
    private final String persistenceUnitRoot;
    private final PersistenceUnitInfoImpl persistenceUnitInfo;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionManagerImpl transactionManager;
    private final SingleElementCollection<ExtendedEntityManagerRegistry> entityManagerRegistry;

    public PersistenceUnitGBean(@ParamAttribute(name="persistenceUnitName") String persistenceUnitName, @ParamAttribute(name="persistenceProviderClassName") String persistenceProviderClassName, @ParamAttribute(name="persistenceUnitTransactionType") String persistenceUnitTransactionTypeString, @ParamReference(name="JtaDataSourceWrapper", namingType="JCAConnectionManager") ResourceSource<ResourceException> jtaDataSourceWrapper, @ParamReference(name="NonJtaDataSourceWrapper", namingType="JCAConnectionManager") ResourceSource<ResourceException> nonJtaDataSourceWrapper, @ParamAttribute(name="mappingFileNames") List<String> mappingFileNamesUntyped, @ParamAttribute(name="jarFileUrls") List<String> jarFileUrlsUntyped, @ParamAttribute(name="persistenceUnitRoot") String persistenceUnitRoot, @ParamAttribute(name="managedClassNames") List<String> managedClassNames, @ParamAttribute(name="excludeUnlistedClasses") boolean excludeUnlistedClassesValue, @ParamAttribute(name="properties") Properties properties, @ParamReference(name="TransactionManager", namingType="JTAResource") TransactionManagerImpl transactionManager, @ParamReference(name="EntityManagerRegistry", namingType="GBean") Collection<ExtendedEntityManagerRegistry> entityManagerRegistry, @ParamAttribute(name="persistenceXMLSchemaVersion") String persistenceXMLSchemaVersion, @ParamAttribute(name="sharedCacheMode") SharedCacheMode sharedCacheMode, @ParamAttribute(name="validationMode") ValidationMode validationMode, @ParamReference(name="ValidatorFactory", namingType="ValidatorFactory") ValidatorFactoryGBean validatorFactory, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) throws URISyntaxException, IOException, ResourceException {
        PersistenceUnitTransactionType persistenceUnitTransactionType;
        ArrayList<String> mappingFileNames = mappingFileNamesUntyped == null ? NO_STRINGS : new ArrayList<String>(mappingFileNamesUntyped);
        this.persistenceUnitRoot = persistenceUnitRoot;
        URL rootURL = PersistenceUnitGBean.getPersistenceUnitRoot(bundle, persistenceUnitRoot);
        URI rootUri = rootURL.toURI();
        List<URL> jarFileUrls = NO_URLS;
        if (!excludeUnlistedClassesValue) {
            jarFileUrls = new ArrayList<URL>();
            for (String urlString : jarFileUrlsUntyped) {
                URL url = new URL("jar:" + rootUri.resolve(urlString) + "!/");
                if (url != null) {
                    jarFileUrls.add(url);
                    continue;
                }
                log.warn("jar file {} not found in bundle: {}", (Object)urlString, (Object)bundle.toString());
            }
        }
        classLoader = new BundleClassLoader(bundle, BundleResourceHelper.getSearchWiredBundles((boolean)false), BundleResourceHelper.getConvertResourceUrls((boolean)true));
        if (managedClassNames == null) {
            managedClassNames = NO_STRINGS;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("javax.persistence.validation.factory", validatorFactory.getFactory());
        PersistenceUnitTransactionType persistenceUnitTransactionType2 = persistenceUnitTransactionType = persistenceUnitTransactionTypeString == null ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.valueOf((String)persistenceUnitTransactionTypeString);
        if (persistenceProviderClassName == null) {
            persistenceProviderClassName = "org.apache.openjpa.persistence.PersistenceProviderImpl";
        }
        this.persistenceUnitInfo = new PersistenceUnitInfoImpl(persistenceUnitName, persistenceProviderClassName, persistenceUnitTransactionType, jtaDataSourceWrapper == null ? null : (DataSource)jtaDataSourceWrapper.$getResource(), nonJtaDataSourceWrapper == null ? null : (DataSource)nonJtaDataSourceWrapper.$getResource(), mappingFileNames, jarFileUrls, rootURL, managedClassNames, excludeUnlistedClassesValue, properties, persistenceXMLSchemaVersion, sharedCacheMode, validationMode, classLoader, bundle);
        try {
            Class<?> clazz = classLoader.loadClass(persistenceProviderClassName);
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            this.entityManagerFactory = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, (Map)properties);
        }
        catch (ClassNotFoundException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not locate PersistenceProvider class: " + persistenceProviderClassName + " in classloader " + classLoader, (Throwable)e);
        }
        catch (InstantiationException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.persistenceUnitInfo.destroy();
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        this.transactionManager = transactionManager;
        this.entityManagerRegistry = new SingleElementCollection(entityManagerRegistry);
    }

    private static URL getPersistenceUnitRoot(Bundle bundle, String persistenceUnitRoot) throws MalformedURLException {
        if (persistenceUnitRoot == null || persistenceUnitRoot.equals(".")) {
            return bundle.getEntry("/");
        }
        return bundle.getEntry(persistenceUnitRoot);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManager getEntityManager(boolean transactionScoped, Map properties) {
        if (transactionScoped) {
            return new CMPEntityManagerTxScoped(this.transactionManager, this.getPersistenceUnitName(), this.entityManagerFactory, properties);
        }
        if (this.entityManagerRegistry.getElement() != null) {
            return new CMPEntityManagerExtended((ExtendedEntityManagerRegistry)this.entityManagerRegistry.getElement(), this.entityManagerFactory, properties, this.persistenceUnitInfo.getPersistenceUnitName());
        }
        throw new NullPointerException("No ExtendedEntityManagerRegistry supplied, you cannot use extended persistence contexts");
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }

    public String getPersistenceUnitRoot() {
        return this.persistenceUnitRoot;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceUnitInfo.getPersistenceProviderClassName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitInfo.getTransactionType();
    }

    public DataSource getJtaDataSource() {
        return this.persistenceUnitInfo.getJtaDataSource();
    }

    public DataSource getNonJtaDataSource() {
        return this.persistenceUnitInfo.getNonJtaDataSource();
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnitInfo.getMappingFileNames();
    }

    public List<URL> getJarFileUrls() {
        return this.persistenceUnitInfo.getJarFileUrls();
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitInfo.getPersistenceUnitRootUrl();
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnitInfo.getManagedClassNames();
    }

    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.persistenceUnitInfo.getProperties();
    }

    public ClassLoader getClassLoader() {
        return this.persistenceUnitInfo.getClassLoader();
    }

    public void addTransformer(ClassTransformer classTransformer) {
        this.persistenceUnitInfo.addTransformer(classTransformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.persistenceUnitInfo.getNewTempClassLoader();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.entityManagerFactory.close();
        this.persistenceUnitInfo.destroy();
    }

    public void doFail() {
        this.entityManagerFactory.close();
        this.persistenceUnitInfo.destroy();
    }

    private static class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;
        private final String persistenceProviderClassName;
        private final PersistenceUnitTransactionType persistenceUnitTransactionType;
        private final DataSource jtaDataSource;
        private final DataSource nonJtaDataSource;
        private final List<String> mappingFileNames;
        private final List<URL> jarFileUrls;
        private final URL persistenceUnitRootUrl;
        private final List<String> managedClassNames;
        private final boolean excludeUnlistedClassesValue;
        private final Properties properties;
        private final ClassLoader classLoader;
        private final TemporaryClassLoader tempClassLoader;
        private final List<TransformerWrapper> transformers;
        private final String persistenceXMLSchemaVersion;
        private final SharedCacheMode sharedCacheMode;
        private final ValidationMode validationMode;
        private final Bundle bundle;

        public PersistenceUnitInfoImpl(String persistenceUnitName, String persistenceProviderClassName, PersistenceUnitTransactionType persistenceUnitTransactionType, DataSource jtaDataSource, DataSource nonJtaDataSource, List<String> mappingFileNames, List<URL> jarFileUrls, URL persistenceUnitRootUrl, List<String> managedClassNames, boolean excludeUnlistedClassesValue, Properties properties, String persistenceXMLSchemaVersion, SharedCacheMode sharedCacheMode, ValidationMode validationMode, ClassLoader classLoader, Bundle bundle) {
            this.persistenceUnitName = persistenceUnitName;
            this.persistenceProviderClassName = persistenceProviderClassName;
            this.persistenceUnitTransactionType = persistenceUnitTransactionType;
            this.jtaDataSource = jtaDataSource;
            this.nonJtaDataSource = nonJtaDataSource;
            this.mappingFileNames = mappingFileNames;
            this.jarFileUrls = jarFileUrls;
            this.persistenceUnitRootUrl = persistenceUnitRootUrl;
            this.managedClassNames = managedClassNames;
            this.excludeUnlistedClassesValue = excludeUnlistedClassesValue;
            this.properties = properties;
            this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
            this.sharedCacheMode = sharedCacheMode;
            this.validationMode = validationMode;
            this.classLoader = classLoader;
            this.transformers = new ArrayList<TransformerWrapper>();
            this.tempClassLoader = new TemporaryClassLoader((ClassLoader)new BundleClassLoader(bundle, true, false));
            this.bundle = bundle;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return this.persistenceProviderClassName;
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.persistenceUnitTransactionType;
        }

        public DataSource getJtaDataSource() {
            return this.jtaDataSource;
        }

        public DataSource getNonJtaDataSource() {
            return this.nonJtaDataSource;
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return this.jarFileUrls;
        }

        public URL getPersistenceUnitRootUrl() {
            return this.persistenceUnitRootUrl;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return this.excludeUnlistedClassesValue;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void addTransformer(ClassTransformer classTransformer) {
            TransformerWrapper transformer = new TransformerWrapper(classTransformer, this.bundle);
            this.transformers.add(transformer);
            TransformerAgent.addTransformer((ClassFileTransformer)transformer);
        }

        public ClassLoader getNewTempClassLoader() {
            return this.tempClassLoader;
        }

        private void destroy() {
            for (TransformerWrapper t : this.transformers) {
                TransformerAgent.removeTransformer((ClassFileTransformer)t);
            }
        }

        public String getPersistenceXMLSchemaVersion() {
            return this.persistenceXMLSchemaVersion;
        }

        public SharedCacheMode getSharedCacheMode() {
            return this.sharedCacheMode;
        }

        public ValidationMode getValidationMode() {
            return this.validationMode;
        }
    }
}

