/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.openejb.assembler.classic.BmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.CmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.SingletonSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;

public class EjbContainer
implements GBeanLifecycle {
    private final OpenEjbSystem openEjbSystem;
    private final String id;
    private final Properties properties = new Properties();
    private final String provider;
    private final String type;
    private final Class<? extends ContainerInfo> infoType;

    public EjbContainer(AbstractName abstractName, Class<? extends ContainerInfo> infoType, OpenEjbSystem openEjbSystem, String provider, String type, Properties properties) {
        this.id = EjbContainer.getId(abstractName);
        this.infoType = infoType;
        this.openEjbSystem = openEjbSystem;
        this.provider = provider;
        this.type = type;
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    public static String getId(AbstractName abstractName) {
        return (String)abstractName.getName().get("name");
    }

    protected Object set(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    public String getId() {
        return this.id;
    }

    public OpenEjbSystem getOpenEjbSystem() {
        return this.openEjbSystem;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends ContainerInfo> getInfoType() {
        return this.infoType;
    }

    public void doStart() throws Exception {
        this.openEjbSystem.createContainer(this.getInfoType(), this.id, this.properties, this.provider);
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static Class<? extends ContainerInfo> getInfoType(String type) {
        if ("STATELESS".equalsIgnoreCase(type)) {
            return StatelessSessionContainerInfo.class;
        }
        if ("STATEFUL".equalsIgnoreCase(type)) {
            return StatefulSessionContainerInfo.class;
        }
        if ("BMP_ENTITY".equalsIgnoreCase(type)) {
            return BmpEntityContainerInfo.class;
        }
        if ("CMP_ENTITY".equalsIgnoreCase(type)) {
            return CmpEntityContainerInfo.class;
        }
        if ("CMP2_ENTITY".equalsIgnoreCase(type)) {
            return CmpEntityContainerInfo.class;
        }
        if ("MESSAGE".equalsIgnoreCase(type)) {
            return MdbContainerInfo.class;
        }
        String className = type;
        if (className.endsWith("StatelessContainerGBean")) {
            return StatelessSessionContainerInfo.class;
        }
        if (className.endsWith("StatefulContainerGBean")) {
            return StatefulSessionContainerInfo.class;
        }
        if (className.endsWith("SingletonContainerGBean")) {
            return SingletonSessionContainerInfo.class;
        }
        if (className.endsWith("BmpContainerGBean")) {
            return BmpEntityContainerInfo.class;
        }
        if (className.endsWith("CmpContainerGBean")) {
            return CmpEntityContainerInfo.class;
        }
        return ContainerInfo.class;
    }
}

