/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.SubjectId;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.security.jaas.UsernamePasswordCallbackHandler;
import org.apache.openejb.spi.SecurityService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoSecurityService
implements SecurityService {
    public void init(Properties props) throws Exception {
    }

    public Object login(String user, String pass) throws LoginException {
        return this.login("OpenEJB", user, pass);
    }

    public Object login(String securityRealm, String user, String pass) throws LoginException {
        LoginContext context = ContextManager.login((String)securityRealm, (CallbackHandler)new UsernamePasswordCallbackHandler(user, pass));
        Subject subject = context.getSubject();
        return ContextManager.getSubjectId((Subject)subject);
    }

    public void associate(Object securityIdentity) throws LoginException {
        if (securityIdentity == null) {
            return;
        }
        Subject subject = ContextManager.getRegisteredSubject((SubjectId)((SubjectId)securityIdentity));
        if (subject == null) {
            return;
        }
        ContextManager.setCallers((Subject)subject, (Subject)subject);
    }

    public void unassociate(Object securityIdentity) {
        ContextManager.popCallers(null);
    }

    public boolean isCallerAuthorized(Method method, InterfaceType typee) {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        try {
            CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
            EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
            if (ejbDeployment == null || !ejbDeployment.isSecurityEnabled()) {
                return true;
            }
            String ejbName = deploymentInfo.getEjbName();
            InterfaceType type = deploymentInfo.getInterfaceType(method.getDeclaringClass());
            String name = type == null ? null : type.getSpecName();
            EJBMethodPermission permission = new EJBMethodPermission(ejbName, name, method);
            AccessControlContext accessContext = ContextManager.getCurrentContext();
            if (permission != null) {
                accessContext.checkPermission((Permission)permission);
            }
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public boolean isCallerInRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role must not be null");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null || !ejbDeployment.isSecurityEnabled()) {
            return false;
        }
        return ContextManager.isCallerInRole((String)deploymentInfo.getEjbName(), (String)role);
    }

    public Principal getCallerPrincipal() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null || !ejbDeployment.isSecurityEnabled()) {
            return null;
        }
        Subject callerSubject = ContextManager.getCurrentCaller();
        return ContextManager.getCurrentPrincipal((Subject)callerSubject);
    }

    public Object getSecurityIdentity() {
        return null;
    }

    public void setSecurityIdentity(Object securityIdentity) {
        throw new UnsupportedOperationException();
    }

    public <T> T translateTo(Object securityIdentity, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public Subject getCurrentSubject() {
        throw new UnsupportedOperationException();
    }
}

