/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cluster.stateful.deployment;

import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.security.auth.login.LoginException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.openejb.EjbDeploymentGBean;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.cluster.infra.SessionManagerTracker;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.openejb.Container;
import org.apache.openejb.core.CoreDeploymentInfo;

public class ClusteredStatefulDeployment
extends EjbDeployment {
    private final SessionManager sessionManager;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_SESSION_MANAGER = "SessionManager";

    public ClusteredStatefulDeployment() throws LoginException {
        this.sessionManager = null;
    }

    public ClusteredStatefulDeployment(String objectName, String deploymentId, String ejbName, String homeInterfaceName, String remoteInterfaceName, String localHomeInterfaceName, String localInterfaceName, String serviceEndpointInterfaceName, String beanClassName, ClassLoader classLoader, boolean securityEnabled, String defaultRole, String runAsRole, RunAsSource runAsSource, Map componentContext, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator, GeronimoTransactionManager transactionManager, OpenEjbSystem openEjbSystem, SessionManager sessionManager, Kernel kernel) throws Exception {
        this(objectName, deploymentId, ejbName, homeInterfaceName, remoteInterfaceName, localHomeInterfaceName, localInterfaceName, serviceEndpointInterfaceName, beanClassName, classLoader, securityEnabled, defaultRole, runAsRole, runAsSource, EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)transactionManager, (Kernel)kernel, (ClassLoader)classLoader), unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator, openEjbSystem, sessionManager);
    }

    public ClusteredStatefulDeployment(String objectName, String deploymentId, String ejbName, String homeInterfaceName, String remoteInterfaceName, String localHomeInterfaceName, String localInterfaceName, String serviceEndpointInterfaceName, String beanClassName, ClassLoader classLoader, boolean securityEnabled, String defaultRole, String runAsRole, RunAsSource runAsSource, Context componentContext, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator, OpenEjbSystem openEjbSystem, SessionManager sessionManager) throws LoginException {
        super(objectName, deploymentId, ejbName, homeInterfaceName, remoteInterfaceName, localHomeInterfaceName, localInterfaceName, serviceEndpointInterfaceName, beanClassName, classLoader, securityEnabled, defaultRole, runAsRole, runAsSource, componentContext, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator, openEjbSystem);
        if (null == sessionManager) {
            throw new IllegalArgumentException("sessionManager is required");
        }
        this.sessionManager = sessionManager;
    }

    protected EjbDeployment initialize(CoreDeploymentInfo deploymentInfo) {
        super.initialize(deploymentInfo);
        Container container = deploymentInfo.getContainer();
        if (null == container) {
            throw new IllegalStateException("Container not assigned to deployment " + this.deploymentId);
        }
        if (!(container instanceof SessionManagerTracker)) {
            throw new IllegalStateException("Container for deployment [" + this.deploymentId + "] is not a [" + SessionManagerTracker.class.getName() + "]. It is a [" + container.getClass().getName() + "]");
        }
        SessionManagerTracker sessionManagerTracker = (SessionManagerTracker)container;
        sessionManagerTracker.addSessionManager(this.deploymentId, this.sessionManager);
        return this;
    }

    protected void destroy() {
        Container container;
        CoreDeploymentInfo info = (CoreDeploymentInfo)this.deploymentInfo.get();
        if (null != info && null != (container = info.getContainer())) {
            SessionManagerTracker sessionManagerTracker = (SessionManagerTracker)container;
            sessionManagerTracker.removeSessionManager(this.deploymentId, this.sessionManager);
        }
        super.destroy();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(ClusteredStatefulDeployment.class, ClusteredStatefulDeployment.class, (GBeanInfo)EjbDeploymentGBean.GBEAN_INFO, (String)"StatefulSessionBean");
        builder.addReference(GBEAN_REF_SESSION_MANAGER, SessionManager.class, "GBean");
        builder.setConstructor(new String[]{"objectName", "deploymentId", "ejbName", "homeInterfaceName", "remoteInterfaceName", "localHomeInterfaceName", "localInterfaceName", "serviceEndpointInterfaceName", "beanClassName", "classLoader", "securityEnabled", "defaultRole", "runAsRole", "RunAsSource", "componentContextMap", "unshareableResources", "applicationManagedSecurityResources", "TrackedConnectionAssociator", "TransactionManager", "OpenEjbSystem", GBEAN_REF_SESSION_MANAGER, "kernel"});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

