/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cluster.stateful.container;

import java.rmi.dgc.VMID;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.openejb.cluster.infra.SessionManagerTracker;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadiCache
implements Cache<Object, Instance>,
SessionManagerTracker {
    private final ConcurrentMap<Object, SessionManager> sessionManagersById = new ConcurrentHashMap<Object, SessionManager>();
    private final ConcurrentMap<Object, WadiInstance> localInstances = new ConcurrentHashMap<Object, WadiInstance>();
    private Cache.CacheListener<Instance> listener;
    public static final String SESSION_KEY_ENTRY = "entry";

    public WadiCache() {
    }

    public WadiCache(Cache.CacheListener<Instance> listener) {
        this.setListener(listener);
    }

    public synchronized Cache.CacheListener<Instance> getListener() {
        return this.listener;
    }

    public synchronized void setListener(Cache.CacheListener<Instance> listener) {
        this.listener = listener;
    }

    public SessionManager getSessionManager(Object deploymentId) {
        SessionManager sessionManager = (SessionManager)this.sessionManagersById.get(deploymentId);
        if (sessionManager == null) {
            throw new IllegalStateException("No SessionManager registered for deployment [" + deploymentId + "]");
        }
        return sessionManager;
    }

    @Override
    public void addSessionManager(Object deploymentId, SessionManager sessionManager) {
        this.sessionManagersById.put(deploymentId, sessionManager);
        sessionManager.registerListener((SessionListener)new MigrationListener());
    }

    @Override
    public void removeSessionManager(Object deploymentId, SessionManager sessionManager) {
        this.sessionManagersById.remove(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object primaryKey, Instance instance) {
        if (!primaryKey.equals(instance.primaryKey)) {
            throw new IllegalArgumentException("primaryKey does not equal instance.primaryKey");
        }
        WadiInstance wadiInstance = (WadiInstance)this.localInstances.get(primaryKey);
        if (wadiInstance != null) {
            wadiInstance.lock.lock();
            try {
                if (wadiInstance.getState() != WadiInstanceState.REMOVED) {
                    throw new IllegalStateException("An entry for the key " + primaryKey + " already exists");
                }
                this.localInstances.remove(primaryKey);
            }
            finally {
                wadiInstance.lock.unlock();
            }
        }
        if (!(primaryKey instanceof VMID)) {
            throw new AssertionError((Object)("primaryKey MUST be a " + VMID.class.getName()));
        }
        try {
            Object deploymentId = instance.deploymentInfo.getDeploymentID();
            Session session = this.getSessionManager(deploymentId).createSession(primaryKey.toString());
            this.localInstances.put(primaryKey, new WadiInstance(instance, session));
        }
        catch (SessionAlreadyExistException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Instance checkOut(Object primaryKey) throws Exception {
        int i = 0;
        while (true) {
            block14: {
                if (i >= 10) {
                    this.localInstances.remove(primaryKey);
                    throw new RuntimeException("Cache is corrupted: the entry " + primaryKey + " in the Map 'cache' is in state PASSIVATED");
                }
                WadiInstance wadiInstance = (WadiInstance)this.localInstances.get(primaryKey);
                if (wadiInstance == null) {
                    return null;
                }
                wadiInstance.lock.lock();
                try {
                    switch (wadiInstance.getState()) {
                        case AVAILABLE: {
                            break;
                        }
                        case CHECKED_OUT: {
                            throw new IllegalStateException("The entry " + primaryKey + " is already checked-out");
                        }
                        case PASSIVATED: {
                            this.localInstances.remove(primaryKey, wadiInstance);
                            break block14;
                        }
                        case REMOVED: {
                            Instance instance = null;
                            return instance;
                        }
                    }
                    wadiInstance.setState(WadiInstanceState.CHECKED_OUT);
                    Instance instance = wadiInstance.instance;
                    return instance;
                }
                finally {
                    wadiInstance.lock.unlock();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(Object primaryKey) {
        WadiInstance wadiInstance = (WadiInstance)this.localInstances.get(primaryKey);
        if (wadiInstance == null) {
            return;
        }
        wadiInstance.lock.lock();
        try {
            switch (wadiInstance.getState()) {
                case AVAILABLE: {
                    throw new IllegalStateException("The entry " + primaryKey + " is not checked-out");
                }
                case PASSIVATED: {
                    throw new IllegalStateException("The entry " + primaryKey + " is not checked-out");
                }
                case REMOVED: {
                    return;
                }
            }
            wadiInstance.setState(WadiInstanceState.AVAILABLE);
        }
        finally {
            wadiInstance.lock.unlock();
        }
        wadiInstance.endAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance remove(Object primaryKey) {
        WadiInstance wadiInstance = (WadiInstance)this.localInstances.get(primaryKey);
        if (wadiInstance == null) {
            return null;
        }
        wadiInstance.lock.lock();
        try {
            this.localInstances.remove(primaryKey);
            wadiInstance.setState(WadiInstanceState.REMOVED);
        }
        finally {
            wadiInstance.lock.unlock();
        }
        wadiInstance.release();
        return wadiInstance.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Cache.CacheFilter<Instance> filter) {
        Iterator iterator = this.localInstances.values().iterator();
        while (iterator.hasNext()) {
            WadiInstance wadiInstance = (WadiInstance)iterator.next();
            wadiInstance.lock.lock();
            try {
                if (!filter.matches((Object)wadiInstance.instance)) continue;
                iterator.remove();
                wadiInstance.setState(WadiInstanceState.REMOVED);
            }
            finally {
                wadiInstance.lock.unlock();
            }
        }
    }

    protected WadiInstance getWadiInstance(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session is required");
        }
        Instance instance = (Instance)session.getState(SESSION_KEY_ENTRY);
        if (instance == null) {
            return null;
        }
        return new WadiInstance(instance, session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WadiInstanceState {
        AVAILABLE,
        CHECKED_OUT,
        PASSIVATED,
        REMOVED;

    }

    private static class WadiInstance {
        private final Instance instance;
        private final Session session;
        private final ReentrantLock lock = new ReentrantLock();
        private WadiInstanceState state;

        private WadiInstance(Instance instance, Session session) {
            this.instance = instance;
            this.session = session;
            session.addState(WadiCache.SESSION_KEY_ENTRY, (Object)instance);
        }

        public void release() {
            this.session.release();
        }

        public void endAccess() {
            this.session.addState(WadiCache.SESSION_KEY_ENTRY, (Object)this);
            this.session.onEndAccess();
        }

        private WadiInstanceState getState() {
            this.assertLockHeld();
            return this.state;
        }

        private void setState(WadiInstanceState state) {
            this.assertLockHeld();
            this.state = state;
        }

        private void assertLockHeld() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Entry must be locked");
            }
        }
    }

    protected class MigrationListener
    implements SessionListener {
        private final Logger log = LoggerFactory.getLogger(MigrationListener.class);

        protected MigrationListener() {
        }

        public void notifyInboundSessionMigration(Session session) {
            WadiInstance instance = WadiCache.this.getWadiInstance(session);
            if (instance == null) {
                return;
            }
            try {
                Cache.CacheListener<Instance> listener = WadiCache.this.getListener();
                if (listener != null) {
                    listener.afterLoad((Object)instance.instance);
                }
                WadiCache.this.localInstances.put(((WadiInstance)instance).instance.primaryKey, instance);
            }
            catch (Exception e) {
                this.log.warn("Cannot activate migrated bean entry.", (Throwable)e);
            }
        }

        public void notifyOutboundSessionMigration(Session session) {
            WadiInstance instance = WadiCache.this.getWadiInstance(session);
            if (instance == null) {
                return;
            }
            try {
                Cache.CacheListener<Instance> listener = WadiCache.this.getListener();
                if (listener != null) {
                    listener.beforeStore((Object)instance.instance);
                }
                WadiCache.this.localInstances.remove(((WadiInstance)instance).instance.primaryKey);
            }
            catch (Exception e) {
                this.log.warn("Cannot passivate EJB for migration.", (Throwable)e);
            }
        }

        public void notifySessionDestruction(Session session) {
            WadiInstance instance = WadiCache.this.getWadiInstance(session);
            if (instance == null) {
                return;
            }
            WadiCache.this.localInstances.remove(((WadiInstance)instance).instance.primaryKey);
        }
    }
}

