/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cluster.stateful.container;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorTracker;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorTrackerException;
import org.apache.geronimo.openejb.cluster.infra.SessionManagerTracker;
import org.apache.geronimo.openejb.cluster.stateful.container.WadiCache;
import org.apache.openejb.ClusteredRPCContainer;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.StatefulContainer;
import org.apache.openejb.spi.SecurityService;
import org.codehaus.wadi.core.manager.Manager;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;

public class ClusteredStatefulContainer
extends StatefulContainer
implements SessionManagerTracker,
ClusteredRPCContainer {
    private final Map<Object, Manager> deploymentIdToManager = new HashMap<Object, Manager>();
    private final Map<Object, NetworkConnectorTracker> deploymentIdToNetworkConnectorTracker = new HashMap<Object, NetworkConnectorTracker>();

    public ClusteredStatefulContainer(Object id, SecurityService securityService) {
        super(id, securityService, (Cache)new WadiCache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionManager(Object deploymentId, SessionManager sessionManager) {
        NetworkConnectorTracker networkConnectorTracker;
        ((WadiCache)this.cache).addSessionManager(deploymentId, sessionManager);
        WADISessionManager wadiSessionManager = (WADISessionManager)sessionManager;
        Manager manager = wadiSessionManager.getManager();
        Map<Object, Manager> map = this.deploymentIdToManager;
        synchronized (map) {
            this.deploymentIdToManager.put(deploymentId, manager);
        }
        ServiceSpace serviceSpace = wadiSessionManager.getServiceSpace();
        ServiceRegistry serviceRegistry = serviceSpace.getServiceRegistry();
        try {
            networkConnectorTracker = (NetworkConnectorTracker)serviceRegistry.getStartedService(NetworkConnectorTracker.NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException("Should never occur", e);
        }
        Map<Object, NetworkConnectorTracker> map2 = this.deploymentIdToNetworkConnectorTracker;
        synchronized (map2) {
            this.deploymentIdToNetworkConnectorTracker.put(deploymentId, networkConnectorTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionManager(Object deploymentId, SessionManager sessionManager) {
        ((WadiCache)this.cache).removeSessionManager(deploymentId, sessionManager);
        Map<Object, Object> map = this.deploymentIdToManager;
        synchronized (map) {
            this.deploymentIdToManager.remove(deploymentId);
        }
        map = this.deploymentIdToNetworkConnectorTracker;
        synchronized (map) {
            this.deploymentIdToNetworkConnectorTracker.remove(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI[] getLocations(DeploymentInfo deploymentInfo) {
        Set<URI> connectorURIs;
        NetworkConnectorTracker networkConnectorTracker;
        Object deploymentID = deploymentInfo.getDeploymentID();
        Map<Object, NetworkConnectorTracker> map = this.deploymentIdToNetworkConnectorTracker;
        synchronized (map) {
            networkConnectorTracker = this.deploymentIdToNetworkConnectorTracker.get(deploymentID);
        }
        if (null == networkConnectorTracker) {
            return null;
        }
        try {
            connectorURIs = networkConnectorTracker.getConnectorURIs(deploymentID);
        }
        catch (NetworkConnectorTrackerException e) {
            return null;
        }
        return connectorURIs.toArray(new URI[connectorURIs.size()]);
    }
}

