/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cluster.infra;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.SessionManagerListener;
import org.apache.geronimo.clustering.wadi.RemoteNode;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.openejb.EjbDeploymentIdAccessor;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorTracker;
import org.codehaus.wadi.group.Peer;
import org.codehaus.wadi.servicespace.InvocationMetaData;
import org.codehaus.wadi.servicespace.ServiceProxy;
import org.codehaus.wadi.servicespace.ServiceProxyFactory;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConnectorMonitor
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NetworkConnectorMonitor.class);
    private final Collection<NetworkConnector> connectors;
    private final Collection<EjbDeploymentIdAccessor> idAccessors;
    private final WADISessionManager sessionManager;
    private final String nodeName;
    private final Set<URI> locations;
    private NetworkConnectorTracker localTracker;
    private ServiceProxyFactory trackerProxyFactory;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_NETWORK_CONNECTORS = "NetworkConnectors";
    public static final String GBEAN_REF_EJB_DEP_ID_ACCESSOR = "EjbDeploymentIdAccessor";
    public static final String GBEAN_REF_WADI_SESSION_MANAGER = "WADISessionManager";

    public NetworkConnectorMonitor(Collection<NetworkConnector> connectors, Collection<EjbDeploymentIdAccessor> idAccessors, WADISessionManager sessionManager) {
        if (null == connectors && !(connectors instanceof ReferenceCollection)) {
            throw new IllegalArgumentException("connectors must be a [" + ReferenceCollection.class + "]");
        }
        if (null == idAccessors && !(idAccessors instanceof ReferenceCollection)) {
            throw new IllegalArgumentException("idAccessors must be a [" + ReferenceCollection.class + "]");
        }
        if (null == sessionManager) {
            throw new IllegalArgumentException("sessionManager is required");
        }
        this.connectors = connectors;
        this.idAccessors = idAccessors;
        this.sessionManager = sessionManager;
        this.nodeName = sessionManager.getCluster().getLocalNode().getName();
        this.locations = new HashSet<URI>();
        this.registerListenerForMembershipUpdates(sessionManager);
        this.registerListenerForConnectorUpdates((ReferenceCollection)connectors);
        this.registerListenerForDeploymentUpdates((ReferenceCollection)idAccessors);
    }

    protected void registerListenerForMembershipUpdates(WADISessionManager sessionManager) {
        sessionManager.registerSessionManagerListener(new SessionManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onJoin(Node joiningNode, Set<Node> newHostingNodes) {
                HashSet<URI> clonedLocations;
                Set set = NetworkConnectorMonitor.this.locations;
                synchronized (set) {
                    clonedLocations = new HashSet<URI>(NetworkConnectorMonitor.this.locations);
                }
                for (EjbDeploymentIdAccessor deploymentIdAccessor : NetworkConnectorMonitor.this.idAccessors) {
                    String deploymentId = deploymentIdAccessor.getDeploymentId();
                    ServiceProxy proxy = NetworkConnectorMonitor.this.trackerProxyFactory.getProxy();
                    RemoteNode remoteNode = (RemoteNode)joiningNode;
                    proxy.getInvocationMetaData().setTargets(new Peer[]{remoteNode.getPeer()});
                    NetworkConnectorTracker tracker = (NetworkConnectorTracker)proxy;
                    tracker.registerNetworkConnectorLocations(deploymentId, NetworkConnectorMonitor.this.nodeName, clonedLocations);
                }
            }

            public void onLeave(Node leavingNode, Set<Node> newHostingNodes) {
                String leavingNodeName = leavingNode.getName();
                NetworkConnectorMonitor.this.localTracker.unregisterNetworkConnectorLocations(leavingNodeName);
            }
        });
    }

    protected void registerListenerForDeploymentUpdates(ReferenceCollection deploymentIdAccessors) {
        deploymentIdAccessors.addReferenceCollectionListener(new ReferenceCollectionListener(){

            public void memberAdded(ReferenceCollectionEvent event) {
                EjbDeploymentIdAccessor idAccessor = (EjbDeploymentIdAccessor)event.getMember();
                String deploymentId = idAccessor.getDeploymentId();
                NetworkConnectorMonitor.this.updateTracker(deploymentId);
            }

            public void memberRemoved(ReferenceCollectionEvent event) {
                EjbDeploymentIdAccessor idAccessor = (EjbDeploymentIdAccessor)event.getMember();
                String deploymentId = idAccessor.getDeploymentId();
                NetworkConnectorMonitor.this.removeTracker(deploymentId);
            }
        });
    }

    protected void registerListenerForConnectorUpdates(ReferenceCollection connectors) {
        connectors.addReferenceCollectionListener(new ReferenceCollectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void memberAdded(ReferenceCollectionEvent event) {
                URI uri = this.buildURI(event);
                Set set = NetworkConnectorMonitor.this.locations;
                synchronized (set) {
                    NetworkConnectorMonitor.this.locations.add(uri);
                }
                HashSet<URI> uris = new HashSet<URI>();
                uris.add(uri);
                for (EjbDeploymentIdAccessor deploymentIdAccessor : NetworkConnectorMonitor.this.idAccessors) {
                    String deploymentId = deploymentIdAccessor.getDeploymentId();
                    NetworkConnectorMonitor.this.updateTracker(deploymentId, uris);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void memberRemoved(ReferenceCollectionEvent event) {
                URI uri = this.buildURI(event);
                Set set = NetworkConnectorMonitor.this.locations;
                synchronized (set) {
                    NetworkConnectorMonitor.this.locations.remove(uri);
                }
                HashSet<URI> uris = new HashSet<URI>();
                uris.add(uri);
                for (EjbDeploymentIdAccessor deploymentIdAccessor : NetworkConnectorMonitor.this.idAccessors) {
                    String deploymentId = deploymentIdAccessor.getDeploymentId();
                    NetworkConnectorMonitor.this.removeTracker(deploymentId, uris);
                }
            }

            protected URI buildURI(ReferenceCollectionEvent event) {
                NetworkConnector connector = (NetworkConnector)event.getMember();
                return NetworkConnectorMonitor.this.buildURI(connector);
            }
        });
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.error("See nested", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.trackerProxyFactory = this.newNetworkConnectorTrackerProxy();
        this.localTracker = this.locateLocalNetworkConnectorTracker();
        for (NetworkConnector connector : this.connectors) {
            URI uri = this.buildURI(connector);
            Set<URI> set = this.locations;
            synchronized (set) {
                this.locations.add(uri);
            }
        }
        for (EjbDeploymentIdAccessor deploymentIdAccessor : this.idAccessors) {
            String deploymentId = deploymentIdAccessor.getDeploymentId();
            this.updateTracker(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        Set<URI> set = this.locations;
        synchronized (set) {
            this.locations.clear();
        }
    }

    protected NetworkConnectorTracker locateLocalNetworkConnectorTracker() {
        ServiceSpace serviceSpace = this.sessionManager.getServiceSpace();
        ServiceRegistry serviceRegistry = serviceSpace.getServiceRegistry();
        try {
            return (NetworkConnectorTracker)serviceRegistry.getStartedService(NetworkConnectorTracker.NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected URI buildURI(NetworkConnector connector) {
        URI uri;
        String uriAsString = connector.getProtocol() + "://" + connector.getHost() + ":" + connector.getPort();
        try {
            uri = new URI(uriAsString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URI [" + uriAsString + "] is invalid", e);
        }
        return uri;
    }

    protected ServiceProxyFactory newNetworkConnectorTrackerProxy() {
        ServiceSpace serviceSpace = this.sessionManager.getServiceSpace();
        ServiceProxyFactory proxyFactory = serviceSpace.getServiceProxyFactory(NetworkConnectorTracker.NAME, new Class[]{NetworkConnectorTracker.class});
        InvocationMetaData invocationMetaData = proxyFactory.getInvocationMetaData();
        invocationMetaData.setOneWay(true);
        return proxyFactory;
    }

    protected void updateTrackerForAllDeploymentIds() {
        for (EjbDeploymentIdAccessor deploymentIdAccessor : this.idAccessors) {
            String deploymentId = deploymentIdAccessor.getDeploymentId();
            this.updateTracker(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTracker(Object deploymentId) {
        HashSet<URI> clonedLocations;
        Set<URI> set = this.locations;
        synchronized (set) {
            clonedLocations = new HashSet<URI>(this.locations);
        }
        this.updateTracker(deploymentId, clonedLocations);
    }

    protected void updateTracker(Object deploymentId, Set<URI> locationsToRegister) {
        NetworkConnectorTracker tracker = (NetworkConnectorTracker)this.trackerProxyFactory.getProxy();
        tracker.registerNetworkConnectorLocations(deploymentId, this.nodeName, locationsToRegister);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTracker(Object deploymentId) {
        HashSet<URI> clonedLocations;
        Set<URI> set = this.locations;
        synchronized (set) {
            clonedLocations = new HashSet<URI>(this.locations);
        }
        this.removeTracker(deploymentId, clonedLocations);
    }

    protected void removeTracker(Object deploymentId, Set<URI> locationsToUnregister) {
        NetworkConnectorTracker tracker = (NetworkConnectorTracker)this.trackerProxyFactory.getProxy();
        tracker.unregisterNetworkConnectorLocations(deploymentId, this.nodeName, locationsToUnregister);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"NetworkConnectorMonitor", NetworkConnectorMonitor.class, (String)"GBean");
        infoBuilder.addReference(GBEAN_REF_NETWORK_CONNECTORS, NetworkConnector.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_EJB_DEP_ID_ACCESSOR, EjbDeploymentIdAccessor.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_WADI_SESSION_MANAGER, WADISessionManager.class, "GBean");
        infoBuilder.setConstructor(new String[]{GBEAN_REF_NETWORK_CONNECTORS, GBEAN_REF_EJB_DEP_ID_ACCESSOR, GBEAN_REF_WADI_SESSION_MANAGER});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

