/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cluster.infra;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorTracker;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorTrackerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNetworkConnectorTracker
implements NetworkConnectorTracker {
    private final Map<Object, Set<URI>> idToLocations = new HashMap<Object, Set<URI>>();
    private final Map<String, Set<URI>> nodeNameToLocations = new HashMap<String, Set<URI>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<URI> getConnectorURIs(Object deploymentId) throws NetworkConnectorTrackerException {
        Set<URI> locations;
        Map<Object, Set<URI>> map = this.idToLocations;
        synchronized (map) {
            locations = this.idToLocations.get(deploymentId);
            if (null == locations) {
                throw new NetworkConnectorTrackerException("[" + deploymentId + "] is not registered");
            }
            locations = new HashSet<URI>(locations);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkConnectorLocations(Object deploymentId, String nodeName, Set<URI> locations) {
        Map<Object, Set<URI>> map = this.idToLocations;
        synchronized (map) {
            Set<URI> allLocations = this.idToLocations.get(deploymentId);
            if (null == allLocations) {
                allLocations = new HashSet<URI>();
                this.idToLocations.put(deploymentId, allLocations);
            }
            allLocations.addAll(locations);
            allLocations = this.nodeNameToLocations.get(nodeName);
            if (null == allLocations) {
                allLocations = new HashSet<URI>();
                this.nodeNameToLocations.put(nodeName, allLocations);
            }
            allLocations.addAll(locations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNetworkConnectorLocations(Object deploymentId, String nodeName, Set<URI> locations) {
        Map<Object, Set<URI>> map = this.idToLocations;
        synchronized (map) {
            Set<URI> allLocations = this.idToLocations.get(deploymentId);
            if (null == allLocations) {
                return;
            }
            allLocations.removeAll(locations);
            if (allLocations.isEmpty()) {
                this.idToLocations.remove(deploymentId);
            }
            allLocations = this.nodeNameToLocations.get(nodeName);
            allLocations.removeAll(locations);
            if (allLocations.isEmpty()) {
                this.nodeNameToLocations.remove(nodeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNetworkConnectorLocations(String nodeName) {
        Map<Object, Set<URI>> map = this.idToLocations;
        synchronized (map) {
            Set<URI> locationsToRemove = this.nodeNameToLocations.remove(nodeName);
            if (null == locationsToRemove) {
                return;
            }
            HashMap<Object, Set<URI>> clonedIdToLocations = new HashMap<Object, Set<URI>>(this.idToLocations);
            for (Map.Entry entry : clonedIdToLocations.entrySet()) {
                Set allLocations = (Set)entry.getValue();
                allLocations.removeAll(locationsToRemove);
                if (!allLocations.isEmpty()) continue;
                this.idToLocations.remove(entry.getKey());
            }
        }
    }
}

