/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment.cluster;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.clustering.wadi.BasicWADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.openejb.cluster.infra.BasicNetworkConnectorTrackerServiceHolder;
import org.apache.geronimo.openejb.cluster.infra.NetworkConnectorMonitor;
import org.apache.geronimo.openejb.cluster.stateful.deployment.ClusteredStatefulDeployment;
import org.apache.geronimo.openejb.deployment.BasicEjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.XmlUtil;
import org.apache.geronimo.openejb.deployment.cluster.MapSFSBToContainerIDDeployer;
import org.apache.geronimo.openejb.deployment.cluster.OpenEJBClusteringWADIConverter;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.GerOpenejbClusteringWadiDocument;
import org.apache.geronimo.xbeans.geronimo.GerOpenejbClusteringWadiType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerClusteringDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADIOpenEJBClusteringBuilder
implements ModuleBuilderExtension {
    private static final QName BASE_CLUSTERING_QNAME = GerClusteringDocument.type.getDocumentElementName();
    private static final QName CLUSTERING_WADI_QNAME = GerOpenejbClusteringWadiDocument.type.getDocumentElementName();
    private static final QNameSet CLUSTERING_WADI_QNAME_SET = QNameSet.singleton((QName)CLUSTERING_WADI_QNAME);
    private final String defaultClusteredStatefulContainerId;
    private final EjbDeploymentGBeanNameBuilder beanNameBuilder;
    private final int defaultSweepInterval;
    private final int defaultSessionTimeout;
    private final int defaultNumPartitions;
    private final AbstractNameQuery defaultBackingStrategyFactoryName;
    private final AbstractNameQuery defaultClusterName;
    private final AbstractNameQuery defaultNetworkConnectorName;
    private final Environment defaultEnvironment;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_DFT_CLUSTERED_SFSB_CONT_ID = "defaultClusteredStatefulContainerId";
    public static final String GBEAN_ATTR_DFT_SWEEP_INTERVAL = "defaultSweepInterval";
    public static final String GBEAN_ATTR_DFT_SESSION_TIMEOUT = "defaultSessionTimeout";
    public static final String GBEAN_ATTR_DFT_NUM_PARTITIONS = "defaultNumPartitions";
    public static final String GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME = "defaultBackingStrategyFactoryName";
    public static final String GBEAN_ATTR_DFT_CLUSTER_NAME = "defaultClusterName";
    public static final String GBEAN_ATTR_DFT_NETWORK_CONNECTOR_NAME = "defaultNetworkConnectorName";
    public static final String GBEAN_ATTR_DFT_ENVIRONMENT = "defaultEnvironment";

    public WADIOpenEJBClusteringBuilder(String defaultClusteredStatefulContainerId, int defaultSweepInterval, int defaultSessionTimeout, int defaultNumPartitions, AbstractNameQuery defaultBackingStrategyFactoryName, AbstractNameQuery defaultClusterName, AbstractNameQuery defaultNetworkConnectorName, Environment defaultEnvironment) {
        if (null == defaultClusteredStatefulContainerId) {
            throw new IllegalArgumentException("defaultClusteredStatefulContainerId is required");
        }
        if (defaultSweepInterval < 1) {
            throw new IllegalArgumentException("defaultSweepInterval is lower than 1");
        }
        if (defaultSessionTimeout < 1) {
            throw new IllegalArgumentException("defaultSessionTimeout is lower than 1");
        }
        if (defaultNumPartitions < 1) {
            throw new IllegalArgumentException("defaultNumPartitions is lower than 1");
        }
        if (null == defaultBackingStrategyFactoryName) {
            throw new IllegalArgumentException("defaultBackingStrategyFactoryName is required");
        }
        if (null == defaultClusterName) {
            throw new IllegalArgumentException("defaultClusterName is required");
        }
        if (null == defaultEnvironment) {
            throw new IllegalArgumentException("defaultEnvironment is required");
        }
        if (null == defaultNetworkConnectorName) {
            throw new IllegalArgumentException("defaultNetworkConnectorName is required");
        }
        this.defaultClusteredStatefulContainerId = defaultClusteredStatefulContainerId;
        this.defaultSweepInterval = defaultSweepInterval;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.defaultNumPartitions = defaultNumPartitions;
        this.defaultBackingStrategyFactoryName = defaultBackingStrategyFactoryName;
        this.defaultClusterName = defaultClusterName;
        this.defaultNetworkConnectorName = defaultNetworkConnectorName;
        this.defaultEnvironment = defaultEnvironment;
        this.beanNameBuilder = new BasicEjbDeploymentGBeanNameBuilder();
        new NamespaceDrivenBuilderCollection(Collections.singleton(new NamespaceDrivenBuilder(){

            public void build(XmlObject container, DeploymentContext applicationContext, DeploymentContext moduleContext) throws DeploymentException {
            }

            public void buildEnvironment(XmlObject container, Environment environment) throws DeploymentException {
            }

            public QNameSet getPlanQNameSet() {
                return CLUSTERING_WADI_QNAME_SET;
            }

            public QNameSet getSpecQNameSet() {
                return QNameSet.EMPTY;
            }

            public QName getBaseQName() {
                return BASE_CLUSTERING_QNAME;
            }
        }));
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        EjbModule ejbModule = (EjbModule)module;
        OpenejbGeronimoEjbJarType geronimoEjbJarType = ejbModule.getVendorDD();
        GerOpenejbClusteringWadiType clusteringWadiType = this.getWadiClusterConfig((XmlObject)geronimoEjbJarType);
        if (clusteringWadiType != null) {
            AbstractName sessionManagerName = this.addSessionManager(clusteringWadiType, ejbModule, (DeploymentContext)earContext);
            this.addNetworkConnectorMonitor((DeploymentContext)earContext, sessionManagerName);
            EjbJar ejbJar = ejbModule.getEjbJar();
            for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
                if (!(enterpriseBean instanceof SessionBean)) continue;
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                switch (sessionBean.getSessionType()) {
                    case STATEFUL: {
                        this.replaceByClusteredDeploymentGBean(earContext, ejbModule, sessionManagerName, enterpriseBean);
                    }
                }
            }
        }
    }

    protected void replaceByClusteredDeploymentGBean(EARContext earContext, EjbModule ejbModule, AbstractName sessionManagerName, EnterpriseBean enterpriseBean) throws DeploymentException {
        GBeanData beanInstance;
        AbstractName name = this.beanNameBuilder.createEjbName(earContext, ejbModule, enterpriseBean);
        try {
            beanInstance = earContext.getGBeanInstance(name);
            earContext.removeGBean(name);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("No GBean [" + name + "]", (Throwable)e);
        }
        GBeanData clusteredDeploymentGBean = new GBeanData(beanInstance);
        clusteredDeploymentGBean.setGBeanInfo(ClusteredStatefulDeployment.GBEAN_INFO);
        clusteredDeploymentGBean.setReferencePattern("SessionManager", sessionManagerName);
        try {
            earContext.addGBean(clusteredDeploymentGBean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("See nested", (Throwable)e);
        }
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        EjbModule ejbModule = (EjbModule)module;
        GeronimoEjbJarType tmpGeronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getEjbModule().getAltDDs().get("geronimo-openejb.xml");
        OpenejbGeronimoEjbJarType geronimoEjbJarType = XmlUtil.convertToXmlbeans((GeronimoEjbJarType)tmpGeronimoEjbJarType);
        GerOpenejbClusteringWadiType clusteringWadiType = this.getWadiClusterConfig((XmlObject)geronimoEjbJarType);
        if (null == clusteringWadiType) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        ejbModule.getPreAutoConfigDeployer().add((DynamicDeployer)new MapSFSBToContainerIDDeployer(this.defaultClusteredStatefulContainerId));
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    protected AbstractName addSessionManager(GerOpenejbClusteringWadiType clustering, EjbModule ejbModule, DeploymentContext moduleContext) throws DeploymentException {
        AbstractName name = this.newGBeanName(moduleContext, "WADISessionManager");
        GBeanData beanData = new GBeanData(name, BasicWADISessionManager.class);
        this.setConfigInfo(clustering, ejbModule, beanData);
        this.setCluster(clustering, beanData);
        this.setBackingStrategyFactory(clustering, beanData);
        this.setClusteredServiceHolders(moduleContext, beanData);
        this.addGBean(moduleContext, beanData);
        return name;
    }

    protected void setClusteredServiceHolders(DeploymentContext moduleContext, GBeanData beanData) throws DeploymentException {
        AbstractName name = this.newGBeanName(moduleContext, "NetworkConnectorTrackerHolder");
        GBeanData serviceHolder = new GBeanData(name, BasicNetworkConnectorTrackerServiceHolder.GBEAN_INFO);
        this.addGBean(moduleContext, serviceHolder);
        beanData.setReferencePattern("ServiceHolders", name);
    }

    protected void addNetworkConnectorMonitor(DeploymentContext moduleContext, AbstractName sessionManagerName) throws DeploymentException {
        AbstractName name = this.newGBeanName(moduleContext, "NetworkConnectorMonitor");
        GBeanData networkConnectorMonitor = new GBeanData(name, NetworkConnectorMonitor.GBEAN_INFO);
        networkConnectorMonitor.setReferencePattern("NetworkConnectors", this.defaultNetworkConnectorName);
        networkConnectorMonitor.setReferencePattern("EjbDeploymentIdAccessor", new AbstractNameQuery(ClusteredStatefulDeployment.class.getName()));
        networkConnectorMonitor.setReferencePattern("WADISessionManager", sessionManagerName);
        this.addGBean(moduleContext, networkConnectorMonitor);
    }

    protected AbstractName newGBeanName(DeploymentContext moduleContext, String name) {
        return moduleContext.getNaming().createChildName(moduleContext.getModuleName(), name, "GBean");
    }

    protected void addGBean(DeploymentContext moduleContext, GBeanData beanData) throws DeploymentException {
        try {
            moduleContext.addGBean(beanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void setCluster(GerOpenejbClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetCluster()) {
            this.addAbstractNameQueries(patterns, clustering.getCluster());
        } else {
            patterns.add(this.defaultClusterName);
        }
        beanData.setReferencePatterns("Cluster", patterns);
    }

    protected void setBackingStrategyFactory(GerOpenejbClusteringWadiType clustering, GBeanData beanData) {
        HashSet<AbstractNameQuery> patterns = new HashSet<AbstractNameQuery>();
        if (clustering.isSetBackingStrategyFactory()) {
            this.addAbstractNameQueries(patterns, clustering.getBackingStrategyFactory());
        } else {
            patterns.add(this.defaultBackingStrategyFactoryName);
        }
        beanData.setReferencePatterns("BackingStrategyFactory", patterns);
    }

    protected void addAbstractNameQueries(Set<AbstractNameQuery> patterns, GerPatternType patternType) {
        AbstractNameQuery query = ENCConfigBuilder.buildAbstractNameQuery((GerPatternType)patternType, null, null, null);
        patterns.add(query);
    }

    protected void setConfigInfo(GerOpenejbClusteringWadiType clustering, EjbModule ejbModule, GBeanData beanData) {
        URI serviceSpaceName;
        int sweepInterval = this.getSweepInterval(clustering);
        int numPartitions = this.getNumberOfPartitions(clustering);
        Integer sessionTimeout = this.getSessionTimeout();
        boolean disableReplication = this.isDisableReplication(clustering);
        boolean deltaReplication = this.isDeltaReplication(clustering);
        String ejbModuleName = ejbModule.getName();
        try {
            serviceSpaceName = new URI(ejbModuleName);
        }
        catch (URISyntaxException e) {
            AssertionError error = new AssertionError((Object)("contextPath [" + ejbModuleName + "] cannot be parsed as an URI."));
            throw (AssertionError)((Object)((Throwable)((Object)error)).initCause(e));
        }
        WADISessionManagerConfigInfo configInfo = new WADISessionManagerConfigInfo(serviceSpaceName, sweepInterval, numPartitions, sessionTimeout.intValue(), disableReplication, deltaReplication);
        beanData.setAttribute("wadiConfigInfo", (Object)configInfo);
    }

    protected Integer getSessionTimeout() throws AssertionError {
        return this.defaultSessionTimeout;
    }

    protected int getSweepInterval(GerOpenejbClusteringWadiType clustering) {
        if (clustering.isSetSweepInterval()) {
            return clustering.getSweepInterval().intValue();
        }
        return this.defaultSweepInterval;
    }

    protected boolean isDeltaReplication(GerOpenejbClusteringWadiType clustering) {
        if (clustering.isSetDeltaReplication()) {
            return clustering.getDeltaReplication();
        }
        return false;
    }

    protected boolean isDisableReplication(GerOpenejbClusteringWadiType clustering) {
        if (clustering.isSetDisableReplication()) {
            return clustering.getDisableReplication();
        }
        return false;
    }

    protected int getNumberOfPartitions(GerOpenejbClusteringWadiType clustering) {
        if (clustering.isSetNumPartitions()) {
            return clustering.getNumPartitions().intValue();
        }
        return this.defaultNumPartitions;
    }

    protected GerOpenejbClusteringWadiType getWadiClusterConfig(XmlObject container) throws DeploymentException {
        XmlObject[] items = container.selectChildren(CLUSTERING_WADI_QNAME_SET);
        if (items.length > 1) {
            throw new DeploymentException("Unexpected count of clustering elements in geronimo plan " + items.length + " qnameset: " + CLUSTERING_WADI_QNAME_SET);
        }
        if (items.length == 1) {
            return (GerOpenejbClusteringWadiType)items[0].copy().changeType(GerOpenejbClusteringWadiType.type);
        }
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(CLUSTERING_WADI_QNAME.getLocalPart(), new OpenEJBClusteringWADIConverter()));
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI OpenEJB Clusteting Builder", WADIOpenEJBClusteringBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_CLUSTERED_SFSB_CONT_ID, String.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_SWEEP_INTERVAL, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_SESSION_TIMEOUT, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_NUM_PARTITIONS, Integer.TYPE, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME, AbstractNameQuery.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_CLUSTER_NAME, AbstractNameQuery.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_NETWORK_CONNECTOR_NAME, AbstractNameQuery.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_DFT_ENVIRONMENT, Environment.class, true);
        infoBuilder.setConstructor(new String[]{GBEAN_ATTR_DFT_CLUSTERED_SFSB_CONT_ID, GBEAN_ATTR_DFT_SWEEP_INTERVAL, GBEAN_ATTR_DFT_SESSION_TIMEOUT, GBEAN_ATTR_DFT_NUM_PARTITIONS, GBEAN_ATTR_DFT_BACKING_STRATEGY_FACTORY_NAME, GBEAN_ATTR_DFT_CLUSTER_NAME, GBEAN_ATTR_DFT_NETWORK_CONNECTOR_NAME, GBEAN_ATTR_DFT_ENVIRONMENT});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

